﻿using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Models.Database.StoredProcedures.App.User.Level;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.Extensions.Configuration;
using Farakonesh.Models.Database.StoredProcedures.App.User.InternalNumbers;

namespace Farakonesh.Logic.Database.User
{
    public class InternalNumbersContext: IInternalNumbersContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Update_InternalNumbers.Inputs, Update_InternalNumbers.Outputs> _Update_InternalNumbers;
        private readonly DP.DapperORM.BaseSP<Insert_InternalNumbers.Inputs, Insert_InternalNumbers.Outputs> _Insert_InternalNumbers;
        private readonly DP.DapperORM.BaseSP<Delete_InternalNumbers.Inputs, Delete_InternalNumbers.Outputs> _Delete_InternalNumbers;
        private readonly DP.DapperORM.BaseSP<GetInternalNumbersByAdmin.Inputs, GetInternalNumbersByAdmin.Outputs> _GetInternalNumbersByAdmin;

        public InternalNumbersContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Update_InternalNumbers = new DP.DapperORM.BaseSP<Update_InternalNumbers.Inputs, Update_InternalNumbers.Outputs>("User.Update_InternalNumbers", executer);
            _Insert_InternalNumbers = new DP.DapperORM.BaseSP<Insert_InternalNumbers.Inputs, Insert_InternalNumbers.Outputs>("User.Insert_InternalNumbers", executer);
            _Delete_InternalNumbers = new DP.DapperORM.BaseSP<Delete_InternalNumbers.Inputs, Delete_InternalNumbers.Outputs>("User.Delete_InternalNumbers", executer);
            _GetInternalNumbersByAdmin = new DP.DapperORM.BaseSP<GetInternalNumbersByAdmin.Inputs, GetInternalNumbersByAdmin.Outputs>("User.GetInternalNumbersByAdmin", executer);

        }

        public async Task<DBResult> Update_InternalNumbers(Update_InternalNumbers.Inputs inputs, CancellationToken cancellationToken) { return await _Update_InternalNumbers.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_InternalNumbers(Insert_InternalNumbers.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_InternalNumbers.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_InternalNumbers(Delete_InternalNumbers.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_InternalNumbers.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetInternalNumbersByAdmin.Outputs>>> GetInternalNumbersByAdmin(GetInternalNumbersByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetInternalNumbersByAdmin.Query(inputs, cancellationToken); }

    }
}
