﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Models.Database.StoredProcedures.App.User.Level;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.User
{
    public class LevelContext: ILevelContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties


        #region SP_User
        private readonly DP.DapperORM.BaseSP<Update_Level.Inputs, Update_Level.Outputs> _Update_Level;
        private readonly DP.DapperORM.BaseSP<Insert_Level.Inputs, Insert_Level.Outputs> _Insert_Level;
        private readonly DP.DapperORM.BaseSP<Delete_Level.Inputs, Delete_Level.Outputs> _Delete_Level;
        private readonly DP.DapperORM.BaseSP<GetLevelList.Inputs, GetLevelList.Outputs> _GetLevelList;
        #endregion SP_User

        public LevelContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Update_Level = new DP.DapperORM.BaseSP<Update_Level.Inputs, Update_Level.Outputs>("User.Update_Level", executer);
            _Insert_Level = new DP.DapperORM.BaseSP<Insert_Level.Inputs, Insert_Level.Outputs>("User.Insert_Level", executer);
            _Delete_Level = new DP.DapperORM.BaseSP<Delete_Level.Inputs, Delete_Level.Outputs>("User.Delete_Level", executer);
            _GetLevelList = new DP.DapperORM.BaseSP<GetLevelList.Inputs, GetLevelList.Outputs>("User.GetLevelList", executer);

        }

        public async Task<DBResult> Update_Level(Update_Level.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Level.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Level(Insert_Level.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Level.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Level(Delete_Level.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Level.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetLevelList.Outputs>>> GetLevelList(GetLevelList.Inputs inputs, CancellationToken cancellationToken) { return await _GetLevelList.Query(inputs,cancellationToken); }

    }
}
