﻿using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.User
{
    public class PartContext : IPartContext
    {
        private readonly DP.DapperORM.BaseSP<GetPart.Inputs, GetPart.Outputs> _GetPart;
        private readonly DP.DapperORM.BaseSP<Insert_Part.Inputs, Insert_Part.Outputs> _Insert_Part;
        private readonly DP.DapperORM.BaseSP<Update_Part.Inputs, Update_Part.Outputs> _Update_Part;
        private readonly DP.DapperORM.BaseSP<Delete_Part.Inputs, Delete_Part.Outputs> _Delete_Part;
        private readonly DP.DapperORM.BaseSP<Delete_Part_User.Inputs, Delete_Part_User.Outputs> _Delete_Part_User;
        private readonly DP.DapperORM.BaseSP<Insert_Part_User.Inputs, Insert_Part_User.Outputs> _Insert_Part_User;
        private readonly DP.DapperORM.BaseSP<GetPartUser.Inputs, GetPartUser.Outputs> _GetPartUser;

        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        public PartContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _GetPart = new DP.DapperORM.BaseSP<GetPart.Inputs, GetPart.Outputs>("User.GetPart", executer);
            _GetPartUser = new DP.DapperORM.BaseSP<GetPartUser.Inputs, GetPartUser.Outputs>("User.GetPartUser", executer);
            _Delete_Part_User = new DP.DapperORM.BaseSP<Delete_Part_User.Inputs, Delete_Part_User.Outputs>("User.Delete_Part_User", executer);
            _Insert_Part_User = new DP.DapperORM.BaseSP<Insert_Part_User.Inputs, Insert_Part_User.Outputs>("User.Insert_Part_User", executer);
            _Delete_Part = new DP.DapperORM.BaseSP<Delete_Part.Inputs, Delete_Part.Outputs>("User.Delete_Part", executer);
            _Insert_Part = new DP.DapperORM.BaseSP<Insert_Part.Inputs, Insert_Part.Outputs>("User.Insert_Part", executer);
            _Update_Part = new DP.DapperORM.BaseSP<Update_Part.Inputs, Update_Part.Outputs>("User.Update_Part", executer);
        }
        public async Task<DBResult<IEnumerable<GetPart.Outputs>>> GetPart(GetPart.Inputs inputs, CancellationToken cancellationToken) { return await _GetPart.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetPartUser.Outputs>>> GetPartUser(GetPartUser.Inputs inputs, CancellationToken cancellationToken) { return await _GetPartUser.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Part(Insert_Part.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Part.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Part_User(Insert_Part_User.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Part_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Part(Update_Part.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Part.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Part(Delete_Part.Inputs inputs, CancellationToken cancellationToken) {return await _Delete_Part.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Part_User(Delete_Part_User.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Part_User.Execute(inputs, cancellationToken); }
    }
}
