﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.User
{
    public class SubjectContext: ISubjectContext
    {
        private readonly DP.DapperORM.BaseSP<GetSubject.Inputs, GetSubject.Outputs> _GetSubject;
        private readonly DP.DapperORM.BaseSP<GetSubject_User.Inputs, GetSubject_User.Outputs> _GetSubject_User;
        private readonly DP.DapperORM.BaseSP<GetSubject_UserAll.Inputs, GetSubject_UserAll.Outputs> _GetSubject_UserAll;
        private readonly DP.DapperORM.BaseSP<Insert_Subject.Inputs, Insert_Subject.Outputs> _Insert_Subject;
        private readonly DP.DapperORM.BaseSP<Update_Subject.Inputs, Update_Subject.Outputs> _Update_Subject;
        private readonly DP.DapperORM.BaseSP<Delete_Subject.Inputs, Delete_Subject.Outputs> _Delete_Subject;
        private readonly DP.DapperORM.BaseSP<Insert_Subject_User.Inputs, Insert_Subject_User.Outputs> _Insert_Subject_User;
        
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        public SubjectContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _GetSubject = new DP.DapperORM.BaseSP<GetSubject.Inputs, GetSubject.Outputs>("User.GetSubject", executer);
            _GetSubject_User = new DP.DapperORM.BaseSP<GetSubject_User.Inputs, GetSubject_User.Outputs>("User.GetSubject_User", executer);
            _GetSubject_UserAll = new DP.DapperORM.BaseSP<GetSubject_UserAll.Inputs, GetSubject_UserAll.Outputs>("User.GetSubject_UserAll", executer);
            _Delete_Subject = new DP.DapperORM.BaseSP<Delete_Subject.Inputs, Delete_Subject.Outputs>("User.Delete_Subject", executer);
            _Insert_Subject = new DP.DapperORM.BaseSP<Insert_Subject.Inputs, Insert_Subject.Outputs>("User.Insert_Subject", executer);
            _Update_Subject = new DP.DapperORM.BaseSP<Update_Subject.Inputs, Update_Subject.Outputs>("User.Update_Subject", executer);
            _Insert_Subject_User = new DP.DapperORM.BaseSP<Insert_Subject_User.Inputs, Insert_Subject_User.Outputs>("User.Insert_Subject_User", executer);
        }
        public async Task<DBResult<IEnumerable<GetSubject.Outputs>>> GetSubject(GetSubject.Inputs inputs, CancellationToken cancellationToken) { return await _GetSubject.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetSubject_User.Outputs>>> GetSubject_User(GetSubject_User.Inputs inputs, CancellationToken cancellationToken) { return await _GetSubject_User.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetSubject_UserAll.Outputs>>> GetSubject_UserAll(GetSubject_UserAll.Inputs inputs, CancellationToken cancellationToken) { return await _GetSubject_UserAll.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Subject(Insert_Subject.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Subject.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Subject(Update_Subject.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Subject.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Subject(Delete_Subject.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Subject.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Subject_User(Insert_Subject_User.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Subject_User.Execute(inputs, cancellationToken); }
    }
}
