﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.User
{
    public class TicketContext: ITicketContext
    {
        private readonly DP.DapperORM.BaseSP<GetTicket.Inputs, GetTicket.Outputs> _GetTicket;
        private readonly DP.DapperORM.BaseSP<GetTicketByAdmin.Inputs, GetTicketByAdmin.Outputs> _GetTicketByAdmin;
        private readonly DP.DapperORM.BaseSP<GetTicketById.Inputs, GetTicketById.Outputs> _GetTicketById;
        private readonly DP.DapperORM.BaseSP<GetTicketContent.Inputs, GetTicketContent.Outputs> _GetTicketContent;
        private readonly DP.DapperORM.BaseSP<GetTicketContentByAdmin.Inputs, GetTicketContentByAdmin.Outputs> _GetTicketContentByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_Ticket.Inputs, Insert_Ticket.Outputs> _Insert_Ticket;
        private readonly DP.DapperORM.BaseSP<Insert_TicketContent.Inputs, Insert_TicketContent.Outputs> _Insert_TicketContent;
        private readonly DP.DapperORM.BaseSP<Update_Ticket_Status.Inputs, Update_Ticket_Status.Outputs> _Update_Ticket_Status;
        private readonly DP.DapperORM.BaseSP<Insert_TicketByAdmin.Inputs, Insert_TicketByAdmin.Outputs> _Insert_TicketByAdmin;
        private readonly DP.DapperORM.BaseSP<GetTicketAttachments.Inputs, GetTicketAttachments.Outputs> _GetTicketAttachments;
        private readonly DP.DapperORM.BaseSP<Delete_Ticket.Inputs, Delete_Ticket.Outputs> _Delete_Ticket;
        private readonly DP.DapperORM.BaseSP<GetTicketReportByAdmin.Inputs, GetTicketReportByAdmin.Outputs> _GetTicketReportByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_Ticket_Auto.Inputs, Insert_Ticket_Auto.Outputs> _Insert_Ticket_Auto;

        #region properties
        private string _connectionString { get; set; }
        #endregion properties

        public TicketContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _GetTicket = new DP.DapperORM.BaseSP<GetTicket.Inputs, GetTicket.Outputs>("User.GetTicket", executer);
            _GetTicketByAdmin = new DP.DapperORM.BaseSP<GetTicketByAdmin.Inputs, GetTicketByAdmin.Outputs>("User.GetTicketByAdmin", executer);
            _GetTicketById = new DP.DapperORM.BaseSP<GetTicketById.Inputs, GetTicketById.Outputs>("User.GetTicketById", executer);
            _GetTicketContent = new DP.DapperORM.BaseSP<GetTicketContent.Inputs, GetTicketContent.Outputs>("User.GetTicketContent", executer);
            _GetTicketContentByAdmin = new DP.DapperORM.BaseSP<GetTicketContentByAdmin.Inputs, GetTicketContentByAdmin.Outputs>("User.GetTicketContentByAdmin", executer);
            _Insert_Ticket = new DP.DapperORM.BaseSP<Insert_Ticket.Inputs, Insert_Ticket.Outputs>("User.Insert_Ticket", executer);
            _Insert_TicketContent = new DP.DapperORM.BaseSP<Insert_TicketContent.Inputs, Insert_TicketContent.Outputs>("User.Insert_TicketContent", executer);
            _Update_Ticket_Status = new DP.DapperORM.BaseSP<Update_Ticket_Status.Inputs, Update_Ticket_Status.Outputs>("User.Update_Ticket_Status", executer);
            _Insert_TicketByAdmin = new DP.DapperORM.BaseSP<Insert_TicketByAdmin.Inputs, Insert_TicketByAdmin.Outputs>("User.Insert_TicketByAdmin", executer);
            _GetTicketAttachments = new DP.DapperORM.BaseSP<GetTicketAttachments.Inputs, GetTicketAttachments.Outputs>("User.GetTicketAttachments", executer);
            _Delete_Ticket = new DP.DapperORM.BaseSP<Delete_Ticket.Inputs, Delete_Ticket.Outputs>("User.Delete_Ticket", executer);
            _GetTicketReportByAdmin = new DP.DapperORM.BaseSP<GetTicketReportByAdmin.Inputs, GetTicketReportByAdmin.Outputs>("User.GetTicketReportByAdmin", executer);
            _Insert_Ticket_Auto = new DP.DapperORM.BaseSP<Insert_Ticket_Auto.Inputs, Insert_Ticket_Auto.Outputs>("User.Insert_Ticket_Auto", executer);
        }
        public async Task<DBResult<IEnumerable<GetTicket.Outputs>>> GetTicket(GetTicket.Inputs inputs, CancellationToken cancellationToken) { return await _GetTicket.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetTicketByAdmin.Outputs>>> GetTicketByAdmin(GetTicketByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetTicketByAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<GetTicketById.Outputs>> GetTicketById(GetTicketById.Inputs inputs, CancellationToken cancellationToken) { return await _GetTicketById.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetTicketContent.Outputs>>> GetTicketContent(GetTicketContent.Inputs inputs, CancellationToken cancellationToken) { return await _GetTicketContent.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetTicketContentByAdmin.Outputs>>> GetTicketContentByAdmin(GetTicketContentByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetTicketContentByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Ticket(Insert_Ticket.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Ticket.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Insert_TicketContent.Outputs>> Insert_TicketContent(Insert_TicketContent.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_TicketContent.Single(inputs, cancellationToken); }
        public async Task<DBResult<Update_Ticket_Status.Outputs>> Update_Ticket_Status(Update_Ticket_Status.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Ticket_Status.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_TicketByAdmin.Outputs>> Insert_TicketByAdmin(Insert_TicketByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_TicketByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_Ticket_Auto.Outputs>> Insert_Ticket_Auto(Insert_Ticket_Auto.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Ticket_Auto.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetTicketAttachments.Outputs>>> GetTicketAttachments(GetTicketAttachments.Inputs inputs, CancellationToken cancellationToken) { return await _GetTicketAttachments.Query(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Ticket(Delete_Ticket.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Ticket.Execute(inputs, cancellationToken); }
        public async Task<DBResult<GetTicketReportByAdmin.Outputs>> GetTicketReportByAdmin(GetTicketReportByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetTicketReportByAdmin.Single(inputs, cancellationToken); }
    }
}