﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.ActionLog;
using Farakonesh.Models.Database.StoredProcedures.App.User.Address;
using Farakonesh.Models.Database.StoredProcedures.App.User.Authentication;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using Farakonesh.Models.Database.StoredProcedures.App.User.Level;
using Farakonesh.Models.Database.StoredProcedures.App.User.Location;
using Farakonesh.Models.Database.StoredProcedures.App.User.Survey;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.DP.DapperORM;

namespace Farakonesh.Logic.Database
{
    public class UserContext : IUserContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties


        #region SP_User
        private readonly BaseSP<Insert_WrongInquiry.Inputs, Insert_WrongInquiry.Outputs> _Insert_WrongInquiry;
        private readonly BaseSP<Check_Duplicate_Profile.Inputs, Check_Duplicate_Profile.Outputs> _Check_Duplicate_Profile;
        private readonly BaseSP<Reset_User_Password.Inputs, Reset_User_Password.Outputs> _Reset_User_Password;
        private readonly BaseSP<GetUser.Inputs, GetUser.Outputs> _GetUser;
        private readonly BaseSP<GetUserListSearch.Inputs, GetUserListSearch.Outputs> _GetUserListSearch;
        private readonly DP.DapperORM.BaseSP<Get_Setting_User.Inputs, Get_Setting_User.Outputs> _Get_Setting_User;
        private readonly DP.DapperORM.BaseSP<Get_Setting_User_ByAdmin.Inputs, Get_Setting_User_ByAdmin.Outputs> _Get_Setting_User_ByAdmin;
        private readonly DP.DapperORM.BaseSP<Get_Config_User_Wallet.Inputs, Get_Config_User_Wallet.Outputs> _Get_Config_User_Wallet;
        private readonly DP.DapperORM.BaseSP<Get_Config_User_Wallet_ByCustomer.Inputs, Get_Config_User_Wallet_ByCustomer.Outputs> _Get_Config_User_Wallet_ByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_Setting_User.Inputs, Insert_Setting_User.Outputs> _Insert_Setting_User;
        private readonly DP.DapperORM.BaseSP<Update_User_Wallet_Config.Inputs, Update_User_Wallet_Config.Outputs> _Update_User_Wallet_Config;
        private readonly DP.DapperORM.BaseSP<GetUserList.Inputs, GetUserList.Outputs> _GetUserList;
        private readonly DP.DapperORM.BaseSP<GetUserByIdAdmin.Inputs, GetUserByIdAdmin.Outputs> _GetUserByIdAdmin;
        private readonly DP.DapperORM.BaseSP<Delete_User.Inputs, Delete_User.Outputs> _Delete_User;
        private readonly DP.DapperORM.BaseSP<Insert_User.Inputs, Insert_User.Outputs> _Insert_User;
        private readonly DP.DapperORM.BaseSP<Update_User.Inputs, Update_User.Outputs> _Update_User;
        private readonly DP.DapperORM.BaseSP<Update_PasswordByAdmin.Inputs, Update_PasswordByAdmin.Outputs> _Update_PasswordByAdmin;
        private readonly DP.DapperORM.BaseSP<Update_Profile.Inputs, Update_Profile.Outputs> _Update_Profile;
        private readonly DP.DapperORM.BaseSP<Insert_Document.Inputs, Insert_Document.Outputs> _Insert_Document;
        private readonly DP.DapperORM.BaseSP<Insert_Document_Accept.Inputs, Insert_Document_Accept.Outputs> _Insert_Document_Accept;
        private readonly DP.DapperORM.BaseSP<Update_Password.Inputs, Update_Password.Outputs> _Update_Password;

        private readonly DP.DapperORM.BaseSP<Insert_UserVerifying.Inputs, Insert_UserVerifying.Outputs> _Insert_UserVerifying;

        private readonly DP.DapperORM.BaseSP<GetDocuments.Inputs, GetDocuments.Outputs> _GetDocuments;
        private readonly DP.DapperORM.BaseSP<GetDocumentsByAdmin.Inputs, GetDocumentsByAdmin.Outputs> _GetDocumentsByAdmin;
        private readonly DP.DapperORM.BaseSP<GetProvince.Inputs, GetProvince.Outputs> _GetProvince;
        private readonly DP.DapperORM.BaseSP<GetCity.Inputs, GetCity.Outputs> _GetCity;
        private readonly DP.DapperORM.BaseSP<GetUserVerifying.Inputs, GetUserVerifying.Outputs> _GetUserVerifying;
        private readonly DP.DapperORM.BaseSP<GetUserVerifyingAll.Inputs, GetUserVerifyingAll.Outputs> _GetUserVerifyingAll;
        private readonly DP.DapperORM.BaseSP<Delete_UserVerifying.Inputs, Delete_UserVerifying.Outputs> _Delete_UserVerifying;

        private readonly DP.DapperORM.BaseSP<Insert_Location.Inputs, Insert_Location.Outputs> _Insert_Location;
        private readonly DP.DapperORM.BaseSP<Delete_Location.Inputs, Delete_Location.Outputs> _Delete_Location;
        private readonly DP.DapperORM.BaseSP<Update_Location.Inputs, Update_Location.Outputs> _Update_Location;
        private readonly DP.DapperORM.BaseSP<ResendVerifyCode.Inputs, ResendVerifyCode.Outputs> _ResendVerifyCode;
        private readonly DP.DapperORM.BaseSP<Update_Profile_Avatar.Inputs, Update_Profile_Avatar.Outputs> _Update_Profile_Avatar;
        private readonly DP.DapperORM.BaseSP<Accept_Level_User.Inputs, Accept_Level_User.Outputs> _Accept_Level_User;

        private readonly DP.DapperORM.BaseSP<Update_User_Role.Inputs, Update_User_Role.Outputs> _Update_User_Role;
        private readonly DP.DapperORM.BaseSP<Update_Password_Auto_Generate.Inputs, Update_Password_Auto_Generate.Outputs> _Update_Password_Auto_Generate;
        private readonly DP.DapperORM.BaseSP<Update_Language_User.Inputs, Update_Language_User.Outputs> _Update_Language_User;
        private readonly DP.DapperORM.BaseSP<GetCounts.Inputs, GetCounts.Outputs> _GetCounts;
        private readonly DP.DapperORM.BaseSP<GetMobileList.Inputs, GetMobileList.Outputs> _GetMobileList;
        private readonly DP.DapperORM.BaseSP<GetEmailList.Inputs, GetEmailList.Outputs> _GetEmailList;
        private readonly DP.DapperORM.BaseSP<Update_User_Active_IsActive.Inputs, Update_User_Active_IsActive.Outputs> _Update_User_Active_IsActive;
        private readonly BaseSP<Insert_Survey.Inputs, Insert_Survey.Outputs> _Insert_Survey;
        private readonly BaseSP<Change_User_LockUpdate.Inputs, Change_User_LockUpdate.Outputs> _Change_User_LockUpdate;
        private readonly BaseSP<Get_ActionLogs.Inputs, Get_ActionLogs.Outputs> _Get_ActionLogs;
        private readonly BaseSP<GetFullUser.Inputs, GetFullUser.Outputs> _GetFullUser;
        private readonly BaseSP<Get_ClientTrackingDataExternal.Inputs, Get_ClientTrackingDataExternal.Outputs> _Get_ClientTrackingDataExternal;
        private readonly BaseSP<Insert_ClientTrackingDataExternal.Inputs, Insert_ClientTrackingDataExternal.Outputs> _Insert_ClientTrackingDataExternal;
        private readonly BaseSP<Check_Duplicate_PostalCode.Inputs, Check_Duplicate_PostalCode.Outputs> _Check_Duplicate_PostalCode;
        #endregion SP_User

        public UserContext(IConfiguration configuration)
        {

            _connectionString = configuration.GetConnectionString("cns");
            var executer = new SqlExecuter(_connectionString);

            _Insert_WrongInquiry = new BaseSP<Insert_WrongInquiry.Inputs, Insert_WrongInquiry.Outputs>("User.Insert_WrongInquiry", executer);
            _Check_Duplicate_Profile = new BaseSP<Check_Duplicate_Profile.Inputs, Check_Duplicate_Profile.Outputs>("User.Check_Duplicate_Profile", executer);
            _GetUser = new DP.DapperORM.BaseSP<GetUser.Inputs, GetUser.Outputs>("User.GetUser", executer);
            _Reset_User_Password = new DP.DapperORM.BaseSP<Reset_User_Password.Inputs, Reset_User_Password.Outputs>("User.Reset_User_Password", executer);
            _GetUserListSearch = new DP.DapperORM.BaseSP<GetUserListSearch.Inputs, GetUserListSearch.Outputs>("User.GetUserListSearch", executer);
            _Get_Config_User_Wallet = new DP.DapperORM.BaseSP<Get_Config_User_Wallet.Inputs, Get_Config_User_Wallet.Outputs>("User.Get_Config_User_Wallet", executer);
            _Get_Config_User_Wallet_ByCustomer = new DP.DapperORM.BaseSP<Get_Config_User_Wallet_ByCustomer.Inputs, Get_Config_User_Wallet_ByCustomer.Outputs>("User.Get_Config_User_Wallet_ByCustomer", executer);
            _Insert_Setting_User = new DP.DapperORM.BaseSP<Insert_Setting_User.Inputs, Insert_Setting_User.Outputs>("User.Insert_Setting_User", executer);
            _Update_User_Wallet_Config = new DP.DapperORM.BaseSP<Update_User_Wallet_Config.Inputs, Update_User_Wallet_Config.Outputs>("User.Update_User_Wallet_Config", executer);
            _Get_Setting_User_ByAdmin = new DP.DapperORM.BaseSP<Get_Setting_User_ByAdmin.Inputs, Get_Setting_User_ByAdmin.Outputs>("User.Get_Setting_User_ByAdmin", executer);
            _GetUserList = new DP.DapperORM.BaseSP<GetUserList.Inputs, GetUserList.Outputs>("User.GetUserList", executer);
            _Update_Profile = new DP.DapperORM.BaseSP<Update_Profile.Inputs, Update_Profile.Outputs>("User.Update_Profile", executer);
            _Insert_Document = new DP.DapperORM.BaseSP<Insert_Document.Inputs, Insert_Document.Outputs>("User.Insert_Document", executer);
            _Insert_Document_Accept = new DP.DapperORM.BaseSP<Insert_Document_Accept.Inputs, Insert_Document_Accept.Outputs>("User.Insert_Document_Accept", executer);
            _Update_Password = new DP.DapperORM.BaseSP<Update_Password.Inputs, Update_Password.Outputs>("User.Update_Password", executer);
            _Update_Password_Auto_Generate = new DP.DapperORM.BaseSP<Update_Password_Auto_Generate.Inputs, Update_Password_Auto_Generate.Outputs>("User.Update_Password_Auto_Generate", executer);
            _GetDocuments = new DP.DapperORM.BaseSP<GetDocuments.Inputs, GetDocuments.Outputs>("User.GetDocuments", executer);
            _GetDocumentsByAdmin = new DP.DapperORM.BaseSP<GetDocumentsByAdmin.Inputs, GetDocumentsByAdmin.Outputs>("User.GetDocumentsByAdmin", executer);
            _GetProvince = new DP.DapperORM.BaseSP<GetProvince.Inputs, GetProvince.Outputs>("User.GetProvince", executer);
            _GetCity = new DP.DapperORM.BaseSP<GetCity.Inputs, GetCity.Outputs>("User.GetCity", executer);
            _GetUserVerifying = new DP.DapperORM.BaseSP<GetUserVerifying.Inputs, GetUserVerifying.Outputs>("User.GetUserVerifying", executer);
            _GetUserVerifyingAll = new DP.DapperORM.BaseSP<GetUserVerifyingAll.Inputs, GetUserVerifyingAll.Outputs>("User.GetUserVerifyingAll", executer);

            _Insert_UserVerifying = new DP.DapperORM.BaseSP<Insert_UserVerifying.Inputs, Insert_UserVerifying.Outputs>("User.Insert_UserVerifying", executer);
            _Delete_UserVerifying = new DP.DapperORM.BaseSP<Delete_UserVerifying.Inputs, Delete_UserVerifying.Outputs>("User.Delete_UserVerifying", executer);
            _ResendVerifyCode = new DP.DapperORM.BaseSP<ResendVerifyCode.Inputs, ResendVerifyCode.Outputs>("User.ResendVerifyCode", executer);
            _Delete_User = new DP.DapperORM.BaseSP<Delete_User.Inputs, Delete_User.Outputs>("User.Delete_User", executer);
            _Insert_User = new DP.DapperORM.BaseSP<Insert_User.Inputs, Insert_User.Outputs>("User.Insert_User", executer);
            _Update_User = new DP.DapperORM.BaseSP<Update_User.Inputs, Update_User.Outputs>("User.Update_User", executer);
            _Update_PasswordByAdmin = new DP.DapperORM.BaseSP<Update_PasswordByAdmin.Inputs, Update_PasswordByAdmin.Outputs>("User.Update_PasswordByAdmin", executer);
            _Insert_Location = new DP.DapperORM.BaseSP<Insert_Location.Inputs, Insert_Location.Outputs>("User.Insert_Location", executer);
            _Update_Location = new DP.DapperORM.BaseSP<Update_Location.Inputs, Update_Location.Outputs>("User.Update_Location", executer);
            _Delete_Location = new DP.DapperORM.BaseSP<Delete_Location.Inputs, Delete_Location.Outputs>("User.Delete_Location", executer);
            _Update_Profile_Avatar = new DP.DapperORM.BaseSP<Update_Profile_Avatar.Inputs, Update_Profile_Avatar.Outputs>("User.Update_Profile_Avatar", executer);
            _Accept_Level_User = new DP.DapperORM.BaseSP<Accept_Level_User.Inputs, Accept_Level_User.Outputs>("User.Accept_Level_User", executer);

            _GetUserByIdAdmin = new DP.DapperORM.BaseSP<GetUserByIdAdmin.Inputs, GetUserByIdAdmin.Outputs>("User.GetUserByIdAdmin", executer);
            _Update_User_Role = new DP.DapperORM.BaseSP<Update_User_Role.Inputs, Update_User_Role.Outputs>("User.Update_User_Role", executer);
            _Update_Language_User = new DP.DapperORM.BaseSP<Update_Language_User.Inputs, Update_Language_User.Outputs>("User.Update_Language_User", executer);
            _GetCounts = new DP.DapperORM.BaseSP<GetCounts.Inputs, GetCounts.Outputs>("User.GetCounts", executer);

            _GetMobileList = new DP.DapperORM.BaseSP<GetMobileList.Inputs, GetMobileList.Outputs>("User.GetMobileList", executer);
            _Update_User_Active_IsActive = new DP.DapperORM.BaseSP<Update_User_Active_IsActive.Inputs, Update_User_Active_IsActive.Outputs>("User.Update_User_Active_IsActive", executer);
            _GetEmailList = new DP.DapperORM.BaseSP<GetEmailList.Inputs, GetEmailList.Outputs>("User.GetEmailList", executer);
            _Get_Setting_User = new DP.DapperORM.BaseSP<Get_Setting_User.Inputs, Get_Setting_User.Outputs>("User.Get_Setting_User", executer);
            _Insert_Survey = new DP.DapperORM.BaseSP<Insert_Survey.Inputs, Insert_Survey.Outputs>("User.Insert_Survey", executer);
            _Change_User_LockUpdate = new DP.DapperORM.BaseSP<Change_User_LockUpdate.Inputs, Change_User_LockUpdate.Outputs>("User.Change_User_LockUpdate", executer);
            _Get_ActionLogs = new DP.DapperORM.BaseSP<Get_ActionLogs.Inputs, Get_ActionLogs.Outputs>("User.Get_ActionLogs", executer);
            _GetFullUser = new BaseSP<GetFullUser.Inputs, GetFullUser.Outputs>("User.GetFullUser", executer);
            _Insert_ClientTrackingDataExternal = new BaseSP<Insert_ClientTrackingDataExternal.Inputs, Insert_ClientTrackingDataExternal.Outputs>("User.Insert_ClientTrackingDataExternal", executer);
            _Get_ClientTrackingDataExternal = new BaseSP<Get_ClientTrackingDataExternal.Inputs, Get_ClientTrackingDataExternal.Outputs>("User.Get_ClientTrackingDataExternal", executer);
            _Check_Duplicate_PostalCode = new BaseSP<Check_Duplicate_PostalCode.Inputs, Check_Duplicate_PostalCode.Outputs>("User.Check_Duplicate_PostalCode", executer);
        }
        public async Task<DBResult<GetUser.Outputs>> GetUser(GetUser.Inputs inputs, CancellationToken cancellationToken) { return await _GetUser.Single(inputs, cancellationToken); }
        public async Task<DBResult> Insert_WrongInquiry(Insert_WrongInquiry.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_WrongInquiry.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_ActionLogs.Outputs>>> Get_ActionLogs(Get_ActionLogs.Inputs inputs, CancellationToken cancellationToken) { return await _Get_ActionLogs.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetUserListSearch.Outputs>>> GetUserListSearch(GetUserListSearch.Inputs inputs, CancellationToken cancellationToken) { return await _GetUserListSearch.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetUserList.Outputs>>> GetUserList(GetUserList.Inputs inputs, CancellationToken cancellationToken) { return await _GetUserList.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Update_Profile(Update_Profile.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Profile.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Document(Insert_Document.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Document.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Document_Accept(Insert_Document_Accept.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Document_Accept.Execute(inputs, cancellationToken); }

        public async Task<DBResult> Update_Password(Update_Password.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Password.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Update_Password_Auto_Generate.Outputs>> Update_Password_Auto_Generate(Update_Password_Auto_Generate.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Password_Auto_Generate.Single(inputs, cancellationToken); }
        public async Task<DBResult> Insert_UserVerifying(Insert_UserVerifying.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_UserVerifying.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetDocuments.Outputs>>> GetDocuments(GetDocuments.Inputs inputs, CancellationToken cancellationToken) { return await _GetDocuments.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetDocumentsByAdmin.Outputs>>> GetDocumentsByAdmin(GetDocumentsByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetDocumentsByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetProvince.Outputs>>> GetProvince(GetProvince.Inputs inputs, CancellationToken cancellationToken) { return await _GetProvince.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCity.Outputs>>> GetCity(GetCity.Inputs inputs, CancellationToken cancellationToken) { return await _GetCity.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetUserVerifying.Outputs>>> GetUserVerifying(GetUserVerifying.Inputs inputs, CancellationToken cancellationToken) { return await _GetUserVerifying.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetUserVerifyingAll.Outputs>>> GetUserVerifyingAll(GetUserVerifyingAll.Inputs inputs, CancellationToken cancellationToken) { return await _GetUserVerifyingAll.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Delete_UserVerifying(Delete_UserVerifying.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_UserVerifying.Execute(inputs, cancellationToken); }
        public async Task<DBResult<GetCounts.Outputs>> GetCounts(GetCounts.Inputs inputs, CancellationToken cancellationToken) { return await _GetCounts.Single(inputs, cancellationToken); }
        public async Task<DBResult<ResendVerifyCode.Outputs>> ResendVerifyCode(ResendVerifyCode.Inputs inputs, CancellationToken cancellationToken) { return await _ResendVerifyCode.Single(inputs, cancellationToken); }
        public async Task<DBResult> Delete_User(Delete_User.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Insert_User.Outputs>> Insert_User(Insert_User.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_User.Single(inputs, cancellationToken); }
        public async Task<DBResult> Update_User(Update_User.Inputs inputs, CancellationToken cancellationToken) { return await _Update_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_PasswordByAdmin(Update_PasswordByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Update_PasswordByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Location(Insert_Location.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Location.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Location(Update_Location.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Location.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Location(Delete_Location.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Location.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Profile_Avatar(Update_Profile_Avatar.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Profile_Avatar.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Accept_Level_User.Outputs>> Accept_Level_User(Accept_Level_User.Inputs inputs, CancellationToken cancellationToken) { return await _Accept_Level_User.Single(inputs, cancellationToken); }
        public async Task<DBResult<GetUserByIdAdmin.Outputs>> GetUserByIdAdmin(GetUserByIdAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetUserByIdAdmin.Single(inputs, cancellationToken); }

        public async Task<DBResult> Update_User_Role(Update_User_Role.Inputs inputs, CancellationToken cancellationToken) { return await _Update_User_Role.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Language_User(Update_Language_User.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Language_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_User_Active_IsActive(Update_User_Active_IsActive.Inputs inputs, CancellationToken cancellationToken) { return await _Update_User_Active_IsActive.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetEmailList.Outputs>>> GetEmailList(GetEmailList.Inputs inputs, CancellationToken cancellationToken) { return await _GetEmailList.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetMobileList.Outputs>>> GetMobileList(GetMobileList.Inputs inputs, CancellationToken cancellationToken) { return await _GetMobileList.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_User.Outputs>> Get_Setting_User(Get_Setting_User.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_User.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Setting_User_ByAdmin.Outputs>>> Get_Setting_User_ByAdmin(Get_Setting_User_ByAdmin.Inputs inputs, CancellationToken cancellationToken)
        {
            return await _Get_Setting_User_ByAdmin.Query(inputs, cancellationToken);
        }
        public async Task<DBResult> Insert_Setting_User(Insert_Setting_User.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Setting_User.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_User_Wallet_Config(Update_User_Wallet_Config.Inputs inputs, CancellationToken cancellationToken) { return await _Update_User_Wallet_Config.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Get_Config_User_Wallet.Outputs>> Get_Config_User_Wallet(Get_Config_User_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Config_User_Wallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Config_User_Wallet_ByCustomer.Outputs>> Get_Config_User_Wallet_ByCustomer(Get_Config_User_Wallet_ByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Config_User_Wallet_ByCustomer.Single(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Survey(Insert_Survey.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Survey.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Change_User_LockUpdate(Change_User_LockUpdate.Inputs inputs, CancellationToken cancellationToken) { return await _Change_User_LockUpdate.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Reset_User_Password(Reset_User_Password.Inputs inputs, CancellationToken cancellationToken) { return await _Reset_User_Password.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Check_Duplicate_Profile(Check_Duplicate_Profile.Inputs inputs, CancellationToken cancellationToken) { return await _Check_Duplicate_Profile.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Check_Duplicate_PostalCode(Check_Duplicate_PostalCode.Inputs inputs, CancellationToken cancellationToken) { return await _Check_Duplicate_PostalCode.Execute(inputs, cancellationToken); }
        public async Task<DBResult<GetFullUser.Outputs>> GetFullUser(GetFullUser.Inputs inputs, CancellationToken cancellationToken) { return await _GetFullUser.QueryMultiple(inputs, cancellationToken); }
        public async Task<DBResult<Get_ClientTrackingDataExternal.Outputs>> Get_ClientTrackingDataExternal(Get_ClientTrackingDataExternal.Inputs inputs, CancellationToken cancellationToken) { return await _Get_ClientTrackingDataExternal.Single(inputs, cancellationToken); }
        public async Task<DBResult> Insert_ClientTrackingDataExternal(Insert_ClientTrackingDataExternal.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_ClientTrackingDataExternal.Execute(inputs, cancellationToken); }
    }
}
