﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.IUser;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.DP.DapperORM;

namespace Farakonesh.Logic.Database.User
{
    public class WalletContext: IWalletContext
    {
        #region properties
        private string _connectionString { get; set; }
        #endregion properties


        #region SP_Wallet
        private readonly BaseSP<GetPointWalletOrderByAdmin.Inputs, GetPointWalletOrderByAdmin.Outputs> _GetPointWalletOrderByAdmin;
        private readonly BaseSP<ConvertPointWalletToWallet.Inputs, ConvertPointWalletToWallet.Outputs> _ConvertPointWalletToWallet;
        private readonly DP.DapperORM.BaseSP<Delete_PointWalletOrder.Inputs, Delete_PointWalletOrder.Outputs> _Delete_PointWalletOrder;
        private readonly DP.DapperORM.BaseSP<Insert_PointWalletOrder.Inputs, Insert_PointWalletOrder.Outputs> _Insert_PointWalletOrder;
        private readonly DP.DapperORM.BaseSP<Update_PointWalletOrder.Inputs, Update_PointWalletOrder.Outputs> _Update_PointWalletOrder;
        private readonly DP.DapperORM.BaseSP<GetWallet.Inputs, GetWallet.Outputs> _GetWallet;
        private readonly DP.DapperORM.BaseSP<GetPointWallet.Inputs, GetPointWallet.Outputs> _GetPointWallet;
        private readonly DP.DapperORM.BaseSP<GetPointWalletByAdmin.Inputs, GetPointWalletByAdmin.Outputs> _GetPointWalletByAdmin;
        private readonly DP.DapperORM.BaseSP<CreatePointWalletByCustomer.Inputs, CreatePointWalletByCustomer.Outputs> _CreatePointWalletByCustomer;
        private readonly DP.DapperORM.BaseSP<GetWalletByAdmin.Inputs, GetWalletByAdmin.Outputs> _GetWalletByAdmin;
        private readonly DP.DapperORM.BaseSP<UpdateWallet.Inputs, UpdateWallet.Outputs> _UpdateWallet;
        private readonly DP.DapperORM.BaseSP<UpdatePointWallet.Inputs, UpdatePointWallet.Outputs> _UpdatePointWallet;
        private readonly DP.DapperORM.BaseSP<CreateWallet.Inputs, CreateWallet.Outputs> _CreateWallet;
        private readonly DP.DapperORM.BaseSP<CreatePointWallet.Inputs, CreatePointWallet.Outputs> _CreatePointWallet;
        private readonly DP.DapperORM.BaseSP<CreateWalletByCustomer.Inputs, CreateWalletByCustomer.Outputs> _CreateWalletByCustomer;
        private readonly DP.DapperORM.BaseSP<Update_User_Setting_Wallet.Inputs, Update_User_Setting_Wallet.Outputs> _Update_User_Setting_Wallet;
        private readonly DP.DapperORM.BaseSP<GetCash.Inputs, GetCash.Outputs> _GetCash;
        private readonly DP.DapperORM.BaseSP<GetCashByCustomer.Inputs, GetCashByCustomer.Outputs> _GetCashByCustomer;
        private readonly DP.DapperORM.BaseSP<Insert_CashByCustomer.Inputs, Insert_CashByCustomer.Outputs> _Insert_CashByCustomer;
        private readonly DP.DapperORM.BaseSP<Delete_Cash.Inputs, Delete_Cash.Outputs> _Delete_Cash;
        private readonly DP.DapperORM.BaseSP<Change_Status_Cash.Inputs, Change_Status_Cash.Outputs> _Change_Status_Cash;
        private readonly BaseSP<Insert_CashByAdmin.Inputs, Insert_CashByAdmin.Outputs> _Insert_CashByAdmin;
        private readonly BaseSP<CreateMultiCurrencyWallet.Inputs, CreateMultiCurrencyWallet.Outputs> _CreateMultiCurrencyWallet;
        private readonly BaseSP<GetMultiCurrencyWalletByAdmin.Inputs, GetMultiCurrencyWalletByAdmin.Outputs> _GetMultiCurrencyWalletByAdmin;
        private readonly BaseSP<GetMultiCurrencyWalletByCustomer.Inputs, GetMultiCurrencyWalletByCustomer.Outputs> _GetMultiCurrencyWalletByCustomer;
        #endregion SP_Wallet

        public WalletContext(IConfiguration configuration)
        {

            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _ConvertPointWalletToWallet = new DP.DapperORM.BaseSP<ConvertPointWalletToWallet.Inputs, ConvertPointWalletToWallet.Outputs>("User.ConvertPointWalletToWallet", executer);
            _GetPointWallet = new DP.DapperORM.BaseSP<GetPointWallet.Inputs, GetPointWallet.Outputs>("User.GetPointWallet", executer);
            _GetPointWalletByAdmin = new DP.DapperORM.BaseSP<GetPointWalletByAdmin.Inputs, GetPointWalletByAdmin.Outputs>("User.GetPointWalletByAdmin", executer);
            _CreatePointWalletByCustomer = new DP.DapperORM.BaseSP<CreatePointWalletByCustomer.Inputs, CreatePointWalletByCustomer.Outputs>("User.CreatePointWalletByCustomer", executer);
            _GetWallet = new DP.DapperORM.BaseSP<GetWallet.Inputs, GetWallet.Outputs>("User.GetWallet", executer);
            _GetWalletByAdmin = new DP.DapperORM.BaseSP<GetWalletByAdmin.Inputs, GetWalletByAdmin.Outputs>("User.GetWalletByAdmin", executer);
            _UpdateWallet = new DP.DapperORM.BaseSP<UpdateWallet.Inputs, UpdateWallet.Outputs>("User.UpdateWallet", executer);
            _UpdatePointWallet = new DP.DapperORM.BaseSP<UpdatePointWallet.Inputs, UpdatePointWallet.Outputs>("User.UpdatePointWallet", executer);
            _CreateWallet = new DP.DapperORM.BaseSP<CreateWallet.Inputs, CreateWallet.Outputs>("User.CreateWallet", executer);
            _CreatePointWallet = new DP.DapperORM.BaseSP<CreatePointWallet.Inputs, CreatePointWallet.Outputs>("User.CreatePointWallet", executer);
            _CreateWalletByCustomer = new DP.DapperORM.BaseSP<CreateWalletByCustomer.Inputs, CreateWalletByCustomer.Outputs>("User.CreateWalletByCustomer", executer);
            _Update_User_Setting_Wallet = new DP.DapperORM.BaseSP<Update_User_Setting_Wallet.Inputs, Update_User_Setting_Wallet.Outputs>("User.Update_User_Setting_Wallet", executer);
            _GetCash = new DP.DapperORM.BaseSP<GetCash.Inputs, GetCash.Outputs>("User.GetCash", executer);
            _GetCashByCustomer = new DP.DapperORM.BaseSP<GetCashByCustomer.Inputs, GetCashByCustomer.Outputs>("User.GetCashByCustomer", executer);
            _Insert_CashByCustomer = new DP.DapperORM.BaseSP<Insert_CashByCustomer.Inputs, Insert_CashByCustomer.Outputs>("User.Insert_CashByCustomer", executer);
            _Change_Status_Cash = new DP.DapperORM.BaseSP<Change_Status_Cash.Inputs, Change_Status_Cash.Outputs>("User.Change_Status_Cash", executer);
            _Delete_Cash = new DP.DapperORM.BaseSP<Delete_Cash.Inputs, Delete_Cash.Outputs>("User.Delete_Cash", executer);
            _Insert_CashByAdmin = new DP.DapperORM.BaseSP<Insert_CashByAdmin.Inputs, Insert_CashByAdmin.Outputs>("User.Insert_CashByAdmin", executer);
            _Insert_PointWalletOrder = new DP.DapperORM.BaseSP<Insert_PointWalletOrder.Inputs, Insert_PointWalletOrder.Outputs>("User.Insert_PointWalletOrder", executer);
            _Update_PointWalletOrder = new DP.DapperORM.BaseSP<Update_PointWalletOrder.Inputs, Update_PointWalletOrder.Outputs>("User.Update_PointWalletOrder", executer);
            _Delete_PointWalletOrder = new DP.DapperORM.BaseSP<Delete_PointWalletOrder.Inputs, Delete_PointWalletOrder.Outputs>("User.Delete_PointWalletOrder", executer);
            _GetPointWalletOrderByAdmin = new BaseSP<GetPointWalletOrderByAdmin.Inputs, GetPointWalletOrderByAdmin.Outputs>("User.GetPointWalletOrderByAdmin", executer);
            _GetMultiCurrencyWalletByCustomer = new BaseSP<GetMultiCurrencyWalletByCustomer.Inputs, GetMultiCurrencyWalletByCustomer.Outputs>("User.GetMultiCurrencyWalletByCustomer", executer);
            _GetMultiCurrencyWalletByAdmin = new BaseSP<GetMultiCurrencyWalletByAdmin.Inputs, GetMultiCurrencyWalletByAdmin.Outputs>("User.GetMultiCurrencyWalletByAdmin", executer);
            _CreateMultiCurrencyWallet = new BaseSP<CreateMultiCurrencyWallet.Inputs, CreateMultiCurrencyWallet.Outputs>("User.CreateMultiCurrencyWallet", executer);

        }
        public async Task<DBResult<ConvertPointWalletToWallet.Outputs>> ConvertPointWalletToWallet(ConvertPointWalletToWallet.Inputs inputs, CancellationToken cancellationToken) { return await _ConvertPointWalletToWallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetPointWalletOrderByAdmin.Outputs>>> GetPointWalletOrderByAdmin(GetPointWalletOrderByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetPointWalletOrderByAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Update_PointWalletOrder(Update_PointWalletOrder.Inputs inputs, CancellationToken cancellationToken) { return await _Update_PointWalletOrder.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_PointWalletOrder(Insert_PointWalletOrder.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_PointWalletOrder.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_PointWalletOrder(Delete_PointWalletOrder.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_PointWalletOrder.Execute(inputs, cancellationToken); }
        public async Task<DBResult<GetPointWallet.Outputs>> GetPointWallet(GetPointWallet.Inputs inputs, CancellationToken cancellationToken) { return await _GetPointWallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetPointWalletByAdmin.Outputs>>> GetPointWalletByAdmin(GetPointWalletByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetPointWalletByAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<GetWallet.Outputs>> GetWallet(GetWallet.Inputs inputs, CancellationToken cancellationToken) { return await _GetWallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetWalletByAdmin.Outputs>>> GetWalletByAdmin(GetWalletByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetWalletByAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<UpdateWallet.Outputs>> UpdateWallet(UpdateWallet.Inputs inputs, CancellationToken cancellationToken) { return await _UpdateWallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<UpdatePointWallet.Outputs>> UpdatePointWallet(UpdatePointWallet.Inputs inputs, CancellationToken cancellationToken) { return await _UpdatePointWallet.Single(inputs, cancellationToken); }
        public async Task<DBResult> CreateWallet(CreateWallet.Inputs inputs, CancellationToken cancellationToken) { return await _CreateWallet.Execute(inputs, cancellationToken); }
        public async Task<DBResult> CreatePointWallet(CreatePointWallet.Inputs inputs, CancellationToken cancellationToken) { return await _CreatePointWallet.Execute(inputs, cancellationToken); }
        public async Task<DBResult> CreateWalletByCustomer(CreateWalletByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _CreateWalletByCustomer.Execute(inputs, cancellationToken); }
        public async Task<DBResult> CreatePointWalletByCustomer(CreatePointWalletByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _CreatePointWalletByCustomer.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_User_Setting_Wallet(Update_User_Setting_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Update_User_Setting_Wallet.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_CashByCustomer(Insert_CashByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CashByCustomer.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCash.Outputs>>> GetCash(GetCash.Inputs inputs, CancellationToken cancellationToken) { return await _GetCash.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetCashByCustomer.Outputs>>> GetCashByCustomer(GetCashByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _GetCashByCustomer.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<Change_Status_Cash.Outputs>> Change_Status_Cash(Change_Status_Cash.Inputs inputs, CancellationToken cancellationToken) { return await _Change_Status_Cash.Single(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Cash(Delete_Cash.Inputs inputs, CancellationToken cancellationToken) {return await _Delete_Cash.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Insert_CashByAdmin.Outputs>> Insert_CashByAdmin(Insert_CashByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_CashByAdmin.Single(inputs, cancellationToken); }
        public async Task<DBResult<CreateMultiCurrencyWallet.Outputs>> CreateMultiCurrencyWallet(CreateMultiCurrencyWallet.Inputs inputs, CancellationToken cancellationToken) { return await _CreateMultiCurrencyWallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetMultiCurrencyWalletByAdmin.Outputs>>> GetMultiCurrencyWalletByAdmin(GetMultiCurrencyWalletByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _GetMultiCurrencyWalletByAdmin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetMultiCurrencyWalletByCustomer.Outputs>>> GetMultiCurrencyWalletByCustomer(GetMultiCurrencyWalletByCustomer.Inputs inputs, CancellationToken cancellationToken) { return await _GetMultiCurrencyWalletByCustomer.Query(inputs, cancellationToken); }
    }
}
