﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountInformation;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.dbo
{
    public class AccountInformationContext: IAccountInformationContext
    {
        #region properties
        private string _connectionString { get; set; }
        #endregion properties
        private readonly DP.DapperORM.BaseSP<Insert_AccountInformation.Inputs, Insert_AccountInformation.Outputs> _Insert_AccountInformation;
        private readonly DP.DapperORM.BaseSP<Update_AccountInformation.Inputs, Update_AccountInformation.Outputs> _Update_AccountInformation;
        private readonly DP.DapperORM.BaseSP<Delete_AccountInformation.Inputs, Delete_AccountInformation.Outputs> _Delete_AccountInformation;
        private readonly DP.DapperORM.BaseSP<Get_AccountInformation.Inputs, Get_AccountInformation.Outputs> _Get_AccountInformation;
        public AccountInformationContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Insert_AccountInformation = new DP.DapperORM.BaseSP<Insert_AccountInformation.Inputs, Insert_AccountInformation.Outputs>("dbo.Insert_AccountInformation", executer);
            _Update_AccountInformation = new DP.DapperORM.BaseSP<Update_AccountInformation.Inputs, Update_AccountInformation.Outputs>("dbo.Update_AccountInformation", executer);
            _Get_AccountInformation = new DP.DapperORM.BaseSP<Get_AccountInformation.Inputs, Get_AccountInformation.Outputs>("dbo.Get_AccountInformation", executer);
            _Delete_AccountInformation = new DP.DapperORM.BaseSP<Delete_AccountInformation.Inputs, Delete_AccountInformation.Outputs>("dbo.Delete_AccountInformation", executer);
        }
        public async Task<DBResult> Insert_AccountInformation(Insert_AccountInformation.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_AccountInformation.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_AccountInformation(Update_AccountInformation.Inputs inputs, CancellationToken cancellationToken) { return await _Update_AccountInformation.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_AccountInformation(Delete_AccountInformation.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_AccountInformation.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_AccountInformation.Outputs>>> Get_AccountInformation(Get_AccountInformation.Inputs inputs, CancellationToken cancellationToken) { return await _Get_AccountInformation.Query(inputs, cancellationToken); }
    }
}
