﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountInformation;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.accountService;
using System.Threading;

namespace Farakonesh.Logic.Database.dbo
{
    public class AccountServiceContext: IAccountServiceContext
    {
        #region properties
        private string _connectionString { get; set; }
        #endregion properties
        private readonly DP.DapperORM.BaseSP<Insert_AccountService.Inputs, Insert_AccountService.Outputs> _Insert_AccountService;
        private readonly DP.DapperORM.BaseSP<Update_AccountService.Inputs, Update_AccountService.Outputs> _Update_AccountService;
        private readonly DP.DapperORM.BaseSP<Delete_AccountService.Inputs, Delete_AccountService.Outputs> _Delete_AccountService;
        private readonly DP.DapperORM.BaseSP<Get_AccountService.Inputs, Get_AccountService.Outputs> _Get_AccountService;
        private readonly DP.DapperORM.BaseSP<Get_AccountService_Warning.Inputs, Get_AccountService_Warning.Outputs> _Get_AccountService_Warning;
        private readonly DP.DapperORM.BaseSP<Update_AccountService_Renewal.Inputs, Update_AccountService_Renewal.Outputs> _Update_AccountService_Renewal;
        public AccountServiceContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Insert_AccountService = new DP.DapperORM.BaseSP<Insert_AccountService.Inputs, Insert_AccountService.Outputs>("dbo.Insert_AccountService", executer);
            _Update_AccountService = new DP.DapperORM.BaseSP<Update_AccountService.Inputs, Update_AccountService.Outputs>("dbo.Update_AccountService", executer);
            _Update_AccountService_Renewal = new DP.DapperORM.BaseSP<Update_AccountService_Renewal.Inputs, Update_AccountService_Renewal.Outputs>("dbo.Update_AccountService_Renewal", executer);
            _Get_AccountService = new DP.DapperORM.BaseSP<Get_AccountService.Inputs, Get_AccountService.Outputs>("dbo.Get_AccountService", executer);
            _Get_AccountService_Warning = new DP.DapperORM.BaseSP<Get_AccountService_Warning.Inputs, Get_AccountService_Warning.Outputs>("dbo.Get_AccountService_Warning", executer);
            _Delete_AccountService = new DP.DapperORM.BaseSP<Delete_AccountService.Inputs, Delete_AccountService.Outputs>("dbo.Delete_AccountService", executer);
        }
        public async Task<DBResult> Insert_AccountService(Insert_AccountService.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_AccountService.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_AccountService(Update_AccountService.Inputs inputs, CancellationToken cancellationToken) { return await _Update_AccountService.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_AccountService_Renewal(Update_AccountService_Renewal.Inputs inputs, CancellationToken cancellationToken) { return await _Update_AccountService_Renewal.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_AccountService(Delete_AccountService.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_AccountService.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_AccountService.Outputs>>> Get_AccountService(Get_AccountService.Inputs inputs, CancellationToken cancellationToken) { return await _Get_AccountService.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_AccountService_Warning.Outputs>>> Get_AccountService_Warning(Get_AccountService_Warning.Inputs inputs, CancellationToken cancellationToken) { return await _Get_AccountService_Warning.Query(inputs, cancellationToken); }
    }
}
