﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Crm;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.blackList;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.question;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.dbo
{
    public class BlackListContext: IBlackListContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Insert_BlackList.Inputs, Insert_BlackList.Outputs> _Insert_BlackList;
        private readonly DP.DapperORM.BaseSP<Update_BlackList.Inputs, Update_BlackList.Outputs> _Update_BlackList;
        private readonly DP.DapperORM.BaseSP<Delete_BlackList.Inputs, Delete_BlackList.Outputs> _Delete_BlackList;
        private readonly DP.DapperORM.BaseSP<GetBlackList.Inputs, GetBlackList.Outputs> _GetBlackList;
        public BlackListContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Insert_BlackList = new DP.DapperORM.BaseSP<Insert_BlackList.Inputs, Insert_BlackList.Outputs>("dbo.Insert_BlackList", executer);
            _Update_BlackList = new DP.DapperORM.BaseSP<Update_BlackList.Inputs, Update_BlackList.Outputs>("dbo.Update_BlackList", executer);
            _GetBlackList = new DP.DapperORM.BaseSP<GetBlackList.Inputs, GetBlackList.Outputs>("dbo.GetBlackList", executer);
            _Delete_BlackList = new DP.DapperORM.BaseSP<Delete_BlackList.Inputs, Delete_BlackList.Outputs>("dbo.Delete_BlackList", executer);
        }
        public async Task<DBResult> Insert_BlackList(Insert_BlackList.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_BlackList.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_BlackList(Update_BlackList.Inputs inputs, CancellationToken cancellationToken) { return await _Update_BlackList.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_BlackList(Delete_BlackList.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_BlackList.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetBlackList.Outputs>>> GetBlackList(GetBlackList.Inputs inputs, CancellationToken cancellationToken) { return await _GetBlackList.QueryPagination(inputs, cancellationToken); }
    }
}
