﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.menu;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.dbo
{
    public class MenusContext:IMenusContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Search_Menus.Inputs, Search_Menus.Outputs> _Search_Menus;
        private readonly DP.DapperORM.BaseSP<GetAll_Menus.Inputs, GetAll_Menus.Outputs> _GetAll_Menus;
        private readonly DP.DapperORM.BaseSP<Insert_Menus_Access_Role.Inputs, Insert_Menus_Access_Role.Outputs> _Insert_Menus_Access_Role;
        private readonly DP.DapperORM.BaseSP<Insert_Menu.Inputs, Insert_Menu.Outputs> _Insert_Menu;
        private readonly DP.DapperORM.BaseSP<Update_Menu.Inputs, Update_Menu.Outputs> _Update_Menu;
        private readonly DP.DapperORM.BaseSP<Delete_Menu.Inputs, Delete_Menu.Outputs> _Delete_Menu;
        private readonly DP.DapperORM.BaseSP<Get_Menus.Inputs, Get_Menus.Outputs> _Get_Menus;
        private readonly DP.DapperORM.BaseSP<Get_Access_Menus.Inputs, Get_Access_Menus.Outputs> _Get_Access_Menus;
        private readonly DP.DapperORM.BaseSP<Check_Access_Menus.Inputs, Check_Access_Menus.Outputs> _Check_Access_Menus;

        public MenusContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _Search_Menus = new DP.DapperORM.BaseSP<Search_Menus.Inputs, Search_Menus.Outputs>("dbo.Search_Menus", executer);
            _GetAll_Menus = new DP.DapperORM.BaseSP<GetAll_Menus.Inputs, GetAll_Menus.Outputs>("dbo.GetAll_Menus", executer);
            _Insert_Menus_Access_Role = new DP.DapperORM.BaseSP<Insert_Menus_Access_Role.Inputs, Insert_Menus_Access_Role.Outputs>("dbo.Insert_Menus_Access_Role", executer);
            _Insert_Menu = new DP.DapperORM.BaseSP<Insert_Menu.Inputs, Insert_Menu.Outputs>("dbo.Insert_Menu", executer);
            _Update_Menu = new DP.DapperORM.BaseSP<Update_Menu.Inputs, Update_Menu.Outputs>("dbo.Update_Menu", executer);
            _Delete_Menu = new DP.DapperORM.BaseSP<Delete_Menu.Inputs, Delete_Menu.Outputs>("dbo.Delete_Menu", executer);
            _Get_Menus = new DP.DapperORM.BaseSP<Get_Menus.Inputs, Get_Menus.Outputs>("dbo.Get_Menus", executer);
            _Get_Access_Menus = new DP.DapperORM.BaseSP<Get_Access_Menus.Inputs, Get_Access_Menus.Outputs>("dbo.Get_Access_Menus", executer);
            _Check_Access_Menus = new DP.DapperORM.BaseSP<Check_Access_Menus.Inputs, Check_Access_Menus.Outputs>("dbo.Check_Access_Menus", executer);

        }

        public async Task<DBResult<IEnumerable<Search_Menus.Outputs>>> Search_Menus(Search_Menus.Inputs inputs, CancellationToken cancellationToken) { return await _Search_Menus.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetAll_Menus.Outputs>>> GetAll_Menus(GetAll_Menus.Inputs inputs, CancellationToken cancellationToken) { return await _GetAll_Menus.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Access_Menus.Outputs>>> Get_Access_Menus(Get_Access_Menus.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Access_Menus.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Menus.Outputs>>> Get_Menus(Get_Menus.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Menus.Query(inputs,cancellationToken); }
        public async Task<DBResult> Insert_Menus_Access_Role(Insert_Menus_Access_Role.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Menus_Access_Role.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Check_Access_Menus(Check_Access_Menus.Inputs inputs, CancellationToken cancellationToken) { return await _Check_Access_Menus.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Menu(Insert_Menu.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Menu.Execute(inputs,cancellationToken); }
        public async Task<DBResult> Update_Menu(Update_Menu.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Menu.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Menu(Delete_Menu.Inputs inputs, CancellationToken cancellationToken) {return await _Delete_Menu.Execute(inputs, cancellationToken); }
    }
}
