﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.bank;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.blackList;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.shortLink;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database
{
    public class PublicContext : IPublicContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties


        private readonly DP.DapperORM.BaseSP<Get_Order_Setting.Inputs, Get_Order_Setting.Outputs> _Get_Order_Setting;
        private readonly DP.DapperORM.BaseSP<Get_Order_Setting_WithoutToken.Inputs, Get_Order_Setting_WithoutToken.Outputs> _Get_Order_Setting_WithoutToken;
        private readonly DP.DapperORM.BaseSP<GetBankById.Inputs, GetBankById.Outputs> _GetBankById;
        private readonly DP.DapperORM.BaseSP<Insert_File.Inputs, Insert_File.Outputs> _Insert_File;
        private readonly DP.DapperORM.BaseSP<GetBank.Inputs, GetBank.Outputs> _GetBank;

        private readonly DP.DapperORM.BaseSP<Get_ShortLink.Inputs, Get_ShortLink.Outputs> _Get_ShortLink;
        private readonly DP.DapperORM.BaseSP<Check_IpAccess.Inputs, Check_IpAccess.Outputs> _Check_IpAccess;

        public PublicContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Get_Order_Setting = new DP.DapperORM.BaseSP<Get_Order_Setting.Inputs, Get_Order_Setting.Outputs>("dbo.Get_Order_Setting", executer);
            _Get_Order_Setting_WithoutToken = new DP.DapperORM.BaseSP<Get_Order_Setting_WithoutToken.Inputs, Get_Order_Setting_WithoutToken.Outputs>("dbo.Get_Order_Setting_WithoutToken", executer);
            _GetBankById = new DP.DapperORM.BaseSP<GetBankById.Inputs, GetBankById.Outputs>("dbo.GetBankById", executer);
            _Insert_File = new DP.DapperORM.BaseSP<Insert_File.Inputs, Insert_File.Outputs>("dbo.Insert_File", executer);
            _GetBank = new DP.DapperORM.BaseSP<GetBank.Inputs, GetBank.Outputs>("dbo.GetBank", executer);


            _Get_ShortLink = new DP.DapperORM.BaseSP<Get_ShortLink.Inputs, Get_ShortLink.Outputs>("dbo.Get_ShortLink", executer);
            _Check_IpAccess = new DP.DapperORM.BaseSP<Check_IpAccess.Inputs, Check_IpAccess.Outputs>("dbo.Check_IpAccess", executer);
        }

        public async Task<DBResult<GetBankById.Outputs>> GetBankById(GetBankById.Inputs inputs, CancellationToken cancellationToken) { return await _GetBankById.Single(inputs, cancellationToken); }
        public async Task<DBResult<Insert_File.Outputs>> Insert_File(Insert_File.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_File.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<GetBank.Outputs>>> GetBank(GetBank.Inputs inputs, CancellationToken cancellationToken) { return await _GetBank.Query(inputs, cancellationToken); }

        public async Task<DBResult<Get_ShortLink.Outputs>> Get_ShortLink(Get_ShortLink.Inputs inputs, CancellationToken cancellationToken) { return await _Get_ShortLink.Single(inputs, cancellationToken); }
        public async Task<DBResult> Check_IpAccess(Check_IpAccess.Inputs inputs, CancellationToken cancellationToken) { return await _Check_IpAccess.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Get_Order_Setting.Outputs>> Get_Order_Setting(Get_Order_Setting.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Order_Setting.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Order_Setting_WithoutToken.Outputs>> Get_Order_Setting_WithoutToken(Get_Order_Setting_WithoutToken.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Order_Setting_WithoutToken.Single(inputs, cancellationToken); }

    }
}
