﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.question;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database
{
    public class QuestionsContext : IQuestionsContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Insert_Question.Inputs, Insert_Question.Outputs> _Insert_Question;
        private readonly DP.DapperORM.BaseSP<Update_Question.Inputs, Update_Question.Outputs> _Update_Question;
        private readonly DP.DapperORM.BaseSP<Delete_Question.Inputs, Delete_Question.Outputs> _Delete_Question;
        private readonly DP.DapperORM.BaseSP<Get_Question.Inputs, Get_Question.Outputs> _Get_Question;
        private readonly DP.DapperORM.BaseSP<Get_QuestionByAdmin.Inputs, Get_QuestionByAdmin.Outputs> _Get_QuestionByAdmin;
        public QuestionsContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Insert_Question = new DP.DapperORM.BaseSP<Insert_Question.Inputs, Insert_Question.Outputs>("dbo.Insert_Question", executer);
            _Update_Question = new DP.DapperORM.BaseSP<Update_Question.Inputs, Update_Question.Outputs>("dbo.Update_Question", executer);
            _Get_QuestionByAdmin = new DP.DapperORM.BaseSP<Get_QuestionByAdmin.Inputs, Get_QuestionByAdmin.Outputs>("dbo.Get_QuestionByAdmin", executer);
            _Get_Question = new DP.DapperORM.BaseSP<Get_Question.Inputs, Get_Question.Outputs>("dbo.Get_Question", executer);
            _Delete_Question = new DP.DapperORM.BaseSP<Delete_Question.Inputs, Delete_Question.Outputs>("dbo.Delete_Question", executer);
        }
        public async Task<DBResult> Insert_Question(Insert_Question.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Question.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Question(Update_Question.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Question.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Question(Delete_Question.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Question.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Question.Outputs>>> Get_Question(Get_Question.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Question.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_QuestionByAdmin.Outputs>>> Get_QuestionByAdmin(Get_QuestionByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_QuestionByAdmin.Query(inputs, cancellationToken); }
    }
}
