﻿using Farakonesh.DP.DapperORM;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.question;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.rfm;
using Farakonesh.Models.Database.StoredProcedures.App.Report;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.dbo
{
    public class RFMCategoryDefinitionsContext: IRFMCategoryDefinitionsContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly BaseSP<Get_RFMCategoryDefinitions.Inputs, Get_RFMCategoryDefinitions.Outputs> _Get_RFMCategoryDefinitions;
        private readonly BaseSP<Delete_RFMCategoryDefinitions.Inputs, Delete_RFMCategoryDefinitions.Outputs> _Delete_RFMCategoryDefinitions;
        private readonly BaseSP<Insert_RFMCategoryDefinitions.Inputs, Insert_RFMCategoryDefinitions.Outputs> _Insert_RFMCategoryDefinitions;
        private readonly BaseSP<Update_RFMCategoryDefinitions.Inputs, Update_RFMCategoryDefinitions.Outputs> _Update_RFMCategoryDefinitions;

        public RFMCategoryDefinitionsContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Get_RFMCategoryDefinitions = new BaseSP<Get_RFMCategoryDefinitions.Inputs, Get_RFMCategoryDefinitions.Outputs>("dbo.Get_RFMCategoryDefinitions", executer);
            _Insert_RFMCategoryDefinitions = new BaseSP<Insert_RFMCategoryDefinitions.Inputs, Insert_RFMCategoryDefinitions.Outputs>("dbo.Insert_RFMCategoryDefinitions", executer);
            _Update_RFMCategoryDefinitions = new BaseSP<Update_RFMCategoryDefinitions.Inputs, Update_RFMCategoryDefinitions.Outputs>("dbo.Update_RFMCategoryDefinitions", executer);
            _Delete_RFMCategoryDefinitions = new BaseSP<Delete_RFMCategoryDefinitions.Inputs, Delete_RFMCategoryDefinitions.Outputs>("dbo.Delete_RFMCategoryDefinitions", executer);
        }
        public async Task<DBResult<IEnumerable<Get_RFMCategoryDefinitions.Outputs>>> Get_RFMCategoryDefinitions(Get_RFMCategoryDefinitions.Inputs inputs, CancellationToken cancellationToken) { return await _Get_RFMCategoryDefinitions.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_RFMCategoryDefinitions(Insert_RFMCategoryDefinitions.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_RFMCategoryDefinitions.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_RFMCategoryDefinitions(Update_RFMCategoryDefinitions.Inputs inputs, CancellationToken cancellationToken) { return await _Update_RFMCategoryDefinitions.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_RFMCategoryDefinitions(Delete_RFMCategoryDefinitions.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_RFMCategoryDefinitions.Execute(inputs, cancellationToken); }
    }
}
