﻿using Farakonesh.DP.DapperORM;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.rfm;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.dbo
{
    public class RFMScoreRangeContext: IRFMScoreRangeContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly BaseSP<Get_RFMScoreRange.Inputs, Get_RFMScoreRange.Outputs> _Get_RFMScoreRange;
        private readonly BaseSP<Insert_RFMScoreRange.Inputs, Insert_RFMScoreRange.Outputs> _Insert_RFMScoreRange;
        private readonly BaseSP<Update_RFMScoreRange.Inputs, Update_RFMScoreRange.Outputs> _Update_RFMScoreRange;
        private readonly BaseSP<Delete_RFMScoreRange.Inputs, Delete_RFMScoreRange.Outputs> _Delete_RFMScoreRange;
        public RFMScoreRangeContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new SqlExecuter(_connectionString);
            _Get_RFMScoreRange = new BaseSP<Get_RFMScoreRange.Inputs, Get_RFMScoreRange.Outputs>("dbo.Get_RFMScoreRange", executer);
            _Delete_RFMScoreRange = new BaseSP<Delete_RFMScoreRange.Inputs, Delete_RFMScoreRange.Outputs>("dbo.Delete_RFMScoreRange", executer);
            _Update_RFMScoreRange = new BaseSP<Update_RFMScoreRange.Inputs, Update_RFMScoreRange.Outputs>("dbo.Update_RFMScoreRange", executer);
            _Insert_RFMScoreRange = new BaseSP<Insert_RFMScoreRange.Inputs, Insert_RFMScoreRange.Outputs>("dbo.Insert_RFMScoreRange", executer);
        }
        public async Task<DBResult<IEnumerable<Get_RFMScoreRange.Outputs>>> Get_RFMScoreRange(Get_RFMScoreRange.Inputs inputs, CancellationToken cancellationToken) { return await _Get_RFMScoreRange.Query(inputs, cancellationToken); }
        public async Task<DBResult> Delete_RFMScoreRange(Delete_RFMScoreRange.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_RFMScoreRange.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_RFMScoreRange(Insert_RFMScoreRange.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_RFMScoreRange.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_RFMScoreRange(Update_RFMScoreRange.Inputs inputs, CancellationToken cancellationToken) { return await _Update_RFMScoreRange.Execute(inputs, cancellationToken); }
    }
}
