﻿using Farakonesh.DP.DapperORM;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.blackList;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.keys;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.dbo
{
    public class ServiceKeysContext: IServiceKeysContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly DP.DapperORM.BaseSP<Delete_ServiceKeysByAdmin.Inputs, Delete_ServiceKeysByAdmin.Outputs> _Delete_ServiceKeysByAdmin;
        private readonly DP.DapperORM.BaseSP<Insert_ServiceKeysByAdmin.Inputs, Insert_ServiceKeysByAdmin.Outputs> _Insert_ServiceKeysByAdmin;
        private readonly DP.DapperORM.BaseSP<Update_ServiceKeysByAdmin.Inputs, Update_ServiceKeysByAdmin.Outputs> _Update_ServiceKeysByAdmin;
        private readonly DP.DapperORM.BaseSP<Get_ServiceKeysByAdmin.Inputs, Get_ServiceKeysByAdmin.Outputs> _Get_ServiceKeysByAdmin;
        private readonly BaseSP<Get_ServiceKeys.Inputs, Get_ServiceKeys.Outputs> _Get_ServiceKeys;
        private readonly BaseSP<Update_ServiceKeys_ByJob.Inputs, Update_ServiceKeys_ByJob.Outputs> _Update_ServiceKeys_ByJob;
        public ServiceKeysContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Delete_ServiceKeysByAdmin = new DP.DapperORM.BaseSP<Delete_ServiceKeysByAdmin.Inputs, Delete_ServiceKeysByAdmin.Outputs>("dbo.Delete_ServiceKeysByAdmin", executer);
            _Get_ServiceKeysByAdmin = new DP.DapperORM.BaseSP<Get_ServiceKeysByAdmin.Inputs, Get_ServiceKeysByAdmin.Outputs>("dbo.Get_ServiceKeysByAdmin", executer);
            _Get_ServiceKeys = new BaseSP<Get_ServiceKeys.Inputs, Get_ServiceKeys.Outputs>("dbo.Get_ServiceKeys", executer);
            _Insert_ServiceKeysByAdmin = new DP.DapperORM.BaseSP<Insert_ServiceKeysByAdmin.Inputs, Insert_ServiceKeysByAdmin.Outputs>("dbo.Insert_ServiceKeysByAdmin", executer);
            _Update_ServiceKeysByAdmin = new BaseSP<Update_ServiceKeysByAdmin.Inputs, Update_ServiceKeysByAdmin.Outputs>("dbo.Update_ServiceKeysByAdmin", executer);
            _Update_ServiceKeys_ByJob = new BaseSP<Update_ServiceKeys_ByJob.Inputs, Update_ServiceKeys_ByJob.Outputs>("dbo.Update_ServiceKeys_ByJob", executer);
        }
        public async Task<DBResult> Insert_ServiceKeysByAdmin(Insert_ServiceKeysByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_ServiceKeysByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_ServiceKeysByAdmin(Update_ServiceKeysByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Update_ServiceKeysByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_ServiceKeys_ByJob(Update_ServiceKeys_ByJob.Inputs inputs, CancellationToken cancellationToken) { return await _Update_ServiceKeys_ByJob.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_ServiceKeysByAdmin(Delete_ServiceKeysByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_ServiceKeysByAdmin.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_ServiceKeysByAdmin.Outputs>>> Get_ServiceKeysByAdmin(Get_ServiceKeysByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_ServiceKeysByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_ServiceKeys.Outputs>>> Get_ServiceKeys(Get_ServiceKeys.Inputs inputs, CancellationToken cancellationToken) { return await _Get_ServiceKeys.Query(inputs, cancellationToken); }
    }
}
