﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using StackExchange.Redis;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.DP.DapperORM;

namespace Farakonesh.Logic.Database.dbo
{
    public class SettingContext : ISettingContext
    {
        private readonly BaseSP<Get_VersionSetting.Inputs, Get_VersionSetting.Outputs> _Get_VersionSetting;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Admin.Inputs, Get_Setting_Admin.Outputs> _Get_Setting_Admin;
        private readonly DP.DapperORM.BaseSP<Insert_Setting.Inputs, Insert_Setting.Outputs> _Insert_Setting;
        private readonly DP.DapperORM.BaseSP<Get_Order_Setting_Admin.Inputs, Get_Order_Setting_Admin.Outputs> _Get_Order_Setting_Admin;
        private readonly DP.DapperORM.BaseSP<Insert_Order_Setting.Inputs, Insert_Order_Setting.Outputs> _Insert_Order_Setting;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Checkout.Inputs, Get_Setting_Checkout.Outputs> _Get_Setting_Checkout;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Dashboard.Inputs, Get_Setting_Dashboard.Outputs> _Get_Setting_Dashboard;
        private readonly DP.DapperORM.BaseSP<Get_Setting_TermsConditions.Inputs, Get_Setting_TermsConditions.Outputs> _Get_Setting_TermsConditions;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Purchase_Verify.Inputs, Get_Setting_Purchase_Verify.Outputs> _Get_Setting_Purchase_Verify;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Email.Inputs, Get_Setting_Email.Outputs> _Get_Setting_Email;
        private readonly DP.DapperORM.BaseSP<Get_Setting_SMS.Inputs, Get_Setting_SMS.Outputs> _Get_Setting_SMS;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Basic_System.Inputs, Get_Setting_Basic_System.Outputs> _Get_Setting_Basic_System;
        private readonly DP.DapperORM.BaseSP<Get_Setting_SMS_Email.Inputs, Get_Setting_SMS_Email.Outputs> _Get_Setting_SMS_Email;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Job.Inputs, Get_Setting_Job.Outputs> _Get_Setting_Job;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Domain.Inputs, Get_Setting_Domain.Outputs> _Get_Setting_Domain;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Auth.Inputs, Get_Setting_Auth.Outputs> _Get_Setting_Auth;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Logo_Title_Url.Inputs, Get_Setting_Logo_Title_Url.Outputs> _Get_Setting_Logo_Title_Url;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Security.Inputs, Get_Setting_Security.Outputs> _Get_Setting_Security;
        private readonly DP.DapperORM.BaseSP<Get_Setting_AmountOnlinePort.Inputs, Get_Setting_AmountOnlinePort.Outputs> _Get_Setting_AmountOnlinePort;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Wallet.Inputs, Get_Setting_Wallet.Outputs> _Get_Setting_Wallet;

        private readonly DP.DapperORM.BaseSP<Get_SettingPatternSMS.Inputs, Get_SettingPatternSMS.Outputs> _Get_SettingPatternSMS;
        private readonly DP.DapperORM.BaseSP<Get_SettingPatternSMS_WithoutToken.Inputs, Get_SettingPatternSMS_WithoutToken.Outputs> _Get_SettingPatternSMS_WithoutToken;
        private readonly DP.DapperORM.BaseSP<Insert_SettingPatternSMS.Inputs, Insert_SettingPatternSMS.Outputs> _Insert_SettingPatternSMS;
        private readonly DP.DapperORM.BaseSP<Update_SettingPatternSMS.Inputs, Update_SettingPatternSMS.Outputs> _Update_SettingPatternSMS;
        private readonly DP.DapperORM.BaseSP<Insert_SettingPatternSMS_Group.Inputs, Insert_SettingPatternSMS_Group.Outputs> _Insert_SettingPatternSMS_Group;
        private readonly DP.DapperORM.BaseSP<Delete_SettingPatternSMS.Inputs, Delete_SettingPatternSMS.Outputs> _Delete_SettingPatternSMS;
        private readonly DP.DapperORM.BaseSP<Get_Setting_Telegram.Inputs, Get_Setting_Telegram.Outputs> _Get_Setting_Telegram;
        private readonly DP.DapperORM.BaseSP<Get_Order_SettingList_WithoutToken.Inputs, Get_Order_SettingList_WithoutToken.Outputs> _Get_Order_SettingList_WithoutToken;
        private readonly BaseSP<Get_Setting_WindowsService.Inputs, Get_Setting_WindowsService.Outputs> _Get_Setting_WindowsService;
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        public SettingContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Get_Setting_Logo_Title_Url = new DP.DapperORM.BaseSP<Get_Setting_Logo_Title_Url.Inputs, Get_Setting_Logo_Title_Url.Outputs>("dbo.Get_Setting_Logo_Title_Url", executer);
            _Get_VersionSetting = new DP.DapperORM.BaseSP<Get_VersionSetting.Inputs, Get_VersionSetting.Outputs>("dbo.Get_VersionSetting", executer);
            _Get_Setting_Admin = new DP.DapperORM.BaseSP<Get_Setting_Admin.Inputs, Get_Setting_Admin.Outputs>("dbo.Get_Setting_Admin", executer);
            _Get_Setting_Checkout = new DP.DapperORM.BaseSP<Get_Setting_Checkout.Inputs, Get_Setting_Checkout.Outputs>("dbo.Get_Setting_Checkout", executer);
            _Get_Setting_Purchase_Verify = new DP.DapperORM.BaseSP<Get_Setting_Purchase_Verify.Inputs, Get_Setting_Purchase_Verify.Outputs>("dbo.Get_Setting_Purchase_Verify", executer);
            _Insert_Setting = new DP.DapperORM.BaseSP<Insert_Setting.Inputs, Insert_Setting.Outputs>("dbo.Insert_Setting", executer);
            _Get_Order_Setting_Admin = new DP.DapperORM.BaseSP<Get_Order_Setting_Admin.Inputs, Get_Order_Setting_Admin.Outputs>("dbo.Get_Order_Setting_Admin", executer);
            _Insert_Order_Setting = new DP.DapperORM.BaseSP<Insert_Order_Setting.Inputs, Insert_Order_Setting.Outputs>("dbo.Insert_Order_Setting", executer);
            _Get_Setting_Dashboard = new DP.DapperORM.BaseSP<Get_Setting_Dashboard.Inputs, Get_Setting_Dashboard.Outputs>("dbo.Get_Setting_Dashboard", executer);
            _Get_Setting_TermsConditions = new DP.DapperORM.BaseSP<Get_Setting_TermsConditions.Inputs, Get_Setting_TermsConditions.Outputs>("dbo.Get_Setting_TermsConditions", executer);
            _Get_Setting_SMS = new DP.DapperORM.BaseSP<Get_Setting_SMS.Inputs, Get_Setting_SMS.Outputs>("dbo.Get_Setting_SMS", executer);
            _Get_Setting_Email = new DP.DapperORM.BaseSP<Get_Setting_Email.Inputs, Get_Setting_Email.Outputs>("dbo.Get_Setting_Email", executer);
            _Get_Setting_Basic_System = new DP.DapperORM.BaseSP<Get_Setting_Basic_System.Inputs, Get_Setting_Basic_System.Outputs>("dbo.Get_Setting_Basic_System", executer);
           
            _Get_Setting_SMS_Email = new DP.DapperORM.BaseSP<Get_Setting_SMS_Email.Inputs, Get_Setting_SMS_Email.Outputs>("dbo.Get_Setting_SMS_Email", executer);
            _Get_Setting_Job = new DP.DapperORM.BaseSP<Get_Setting_Job.Inputs, Get_Setting_Job.Outputs>("dbo.Get_Setting_Job", executer);
            _Get_Setting_Domain = new DP.DapperORM.BaseSP<Get_Setting_Domain.Inputs, Get_Setting_Domain.Outputs>("dbo.Get_Setting_Domain", executer);  
            _Get_Setting_Auth = new DP.DapperORM.BaseSP<Get_Setting_Auth.Inputs, Get_Setting_Auth.Outputs>("dbo.Get_Setting_Auth", executer);
            _Get_Setting_Security = new DP.DapperORM.BaseSP<Get_Setting_Security.Inputs, Get_Setting_Security.Outputs>("dbo.Get_Setting_Security", executer);
            _Get_Setting_AmountOnlinePort = new DP.DapperORM.BaseSP<Get_Setting_AmountOnlinePort.Inputs, Get_Setting_AmountOnlinePort.Outputs>("dbo.Get_Setting_AmountOnlinePort", executer);
            _Get_Setting_Wallet = new DP.DapperORM.BaseSP<Get_Setting_Wallet.Inputs, Get_Setting_Wallet.Outputs>("dbo.Get_Setting_Wallet", executer);
            _Get_SettingPatternSMS = new DP.DapperORM.BaseSP<Get_SettingPatternSMS.Inputs, Get_SettingPatternSMS.Outputs>("dbo.Get_SettingPatternSMS", executer);
            _Get_SettingPatternSMS_WithoutToken = new DP.DapperORM.BaseSP<Get_SettingPatternSMS_WithoutToken.Inputs, Get_SettingPatternSMS_WithoutToken.Outputs>("dbo.Get_SettingPatternSMS_WithoutToken", executer);
            _Insert_SettingPatternSMS = new DP.DapperORM.BaseSP<Insert_SettingPatternSMS.Inputs, Insert_SettingPatternSMS.Outputs>("dbo.Insert_SettingPatternSMS", executer);
            _Update_SettingPatternSMS = new DP.DapperORM.BaseSP<Update_SettingPatternSMS.Inputs, Update_SettingPatternSMS.Outputs>("dbo.Update_SettingPatternSMS", executer);
            _Insert_SettingPatternSMS_Group = new DP.DapperORM.BaseSP<Insert_SettingPatternSMS_Group.Inputs, Insert_SettingPatternSMS_Group.Outputs>("dbo.Insert_SettingPatternSMS_Group", executer);
            _Delete_SettingPatternSMS = new DP.DapperORM.BaseSP<Delete_SettingPatternSMS.Inputs, Delete_SettingPatternSMS.Outputs>("dbo.Delete_SettingPatternSMS", executer);
            _Get_Setting_Telegram = new DP.DapperORM.BaseSP<Get_Setting_Telegram.Inputs, Get_Setting_Telegram.Outputs>("dbo.Get_Setting_Telegram", executer);
            _Get_Order_SettingList_WithoutToken = new DP.DapperORM.BaseSP<Get_Order_SettingList_WithoutToken.Inputs, Get_Order_SettingList_WithoutToken.Outputs>("dbo.Get_Order_SettingList_WithoutToken", executer);
            _Get_Setting_WindowsService = new BaseSP<Get_Setting_WindowsService.Inputs, Get_Setting_WindowsService.Outputs>("dbo.Get_Setting_WindowsServer", executer);
        }
        public async Task<DBResult> Delete_SettingPatternSMS(Delete_SettingPatternSMS.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_SettingPatternSMS.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Get_VersionSetting.Outputs>> Get_VersionSetting(Get_VersionSetting.Inputs inputs, CancellationToken cancellationToken) { return await _Get_VersionSetting.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Setting_Admin.Outputs>>> Get_Setting_Admin(Get_Setting_Admin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Admin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Setting(Insert_Setting.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Setting.Execute(inputs, cancellationToken); }

        public async Task<DBResult> Insert_SettingPatternSMS(Insert_SettingPatternSMS.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_SettingPatternSMS.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_SettingPatternSMS(Update_SettingPatternSMS.Inputs inputs, CancellationToken cancellationToken) { return await _Update_SettingPatternSMS.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_SettingPatternSMS_Group(Insert_SettingPatternSMS_Group.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_SettingPatternSMS_Group.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_SettingPatternSMS.Outputs>>> Get_SettingPatternSMS(Get_SettingPatternSMS.Inputs inputs, CancellationToken cancellationToken) { return await _Get_SettingPatternSMS.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_SettingPatternSMS_WithoutToken.Outputs>> Get_SettingPatternSMS_WithoutToken(Get_SettingPatternSMS_WithoutToken.Inputs inputs, CancellationToken cancellationToken) { return await _Get_SettingPatternSMS_WithoutToken.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Order_Setting_Admin.Outputs>>> Get_Order_Setting_Admin(Get_Order_Setting_Admin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Order_Setting_Admin.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Order_Setting(Insert_Order_Setting.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Order_Setting.Execute(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Checkout.Outputs>> Get_Setting_Checkout(Get_Setting_Checkout.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Checkout.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Dashboard.Outputs>> Get_Setting_Dashboard(Get_Setting_Dashboard.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Dashboard.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_TermsConditions.Outputs>> Get_Setting_TermsConditions(Get_Setting_TermsConditions.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_TermsConditions.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Purchase_Verify.Outputs>> Get_Setting_Purchase_Verify(Get_Setting_Purchase_Verify.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Purchase_Verify.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_SMS.Outputs>> Get_Setting_SMS(Get_Setting_SMS.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_SMS.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Email.Outputs>> Get_Setting_Email(Get_Setting_Email.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Email.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Basic_System.Outputs>> Get_Setting_Basic_System(Get_Setting_Basic_System.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Basic_System.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_SMS_Email.Outputs>> Get_Setting_SMS_Email(Get_Setting_SMS_Email.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_SMS_Email.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Job.Outputs>> Get_Setting_Job(Get_Setting_Job.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Job.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Domain.Outputs>> Get_Setting_Domain(Get_Setting_Domain.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Domain.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Auth.Outputs>> Get_Setting_Auth(Get_Setting_Auth.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Auth.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Logo_Title_Url.Outputs>> Get_Setting_Logo_Title_Url(Get_Setting_Logo_Title_Url.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Logo_Title_Url.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Security.Outputs>> Get_Setting_Security(Get_Setting_Security.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Security.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_AmountOnlinePort.Outputs>> Get_Setting_AmountOnlinePort(Get_Setting_AmountOnlinePort.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_AmountOnlinePort.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Wallet.Outputs>> Get_Setting_Wallet(Get_Setting_Wallet.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Wallet.Single(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_Telegram.Outputs>> Get_Setting_Telegram(Get_Setting_Telegram.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Telegram.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Order_SettingList_WithoutToken.Outputs>>> Get_Order_SettingList_WithoutToken(Get_Order_SettingList_WithoutToken.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Order_SettingList_WithoutToken.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_Setting_WindowsService.Outputs>> Get_Setting_WindowsService(Get_Setting_WindowsService.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_WindowsService.Single(inputs, cancellationToken); }
    }
}
