﻿using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.question;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Microsoft.Extensions.Configuration;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.settingJobs;
using Farakonesh.DP.DapperORM;

namespace Farakonesh.Logic.Database.dbo
{
    public class SettingJobsContext: ISettingJobsContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        private readonly BaseSP<Insert_SettingJobs.Inputs, Insert_SettingJobs.Outputs> _Insert_SettingJobs;
        private readonly BaseSP<Update_SettingJobs.Inputs, Update_SettingJobs.Outputs> _Update_SettingJobs;
        private readonly BaseSP<Delete_SettingJobs.Inputs, Delete_SettingJobs.Outputs> _Delete_SettingJobs;
        private readonly BaseSP<Get_SettingJobs.Inputs, Get_SettingJobs.Outputs> _Get_SettingJobs;
        public SettingJobsContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new SqlExecuter(_connectionString);
            _Insert_SettingJobs = new BaseSP<Insert_SettingJobs.Inputs, Insert_SettingJobs.Outputs>("dbo.Insert_SettingJobs", executer);
            _Update_SettingJobs = new BaseSP<Update_SettingJobs.Inputs, Update_SettingJobs.Outputs>("dbo.Update_SettingJobs", executer);
            _Get_SettingJobs = new BaseSP<Get_SettingJobs.Inputs, Get_SettingJobs.Outputs>("dbo.Get_SettingJobs", executer);
            _Delete_SettingJobs = new BaseSP<Delete_SettingJobs.Inputs, Delete_SettingJobs.Outputs>("dbo.Delete_SettingJobs", executer);
        }
        public async Task<DBResult> Insert_SettingJobs(Insert_SettingJobs.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_SettingJobs.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_SettingJobs(Update_SettingJobs.Inputs inputs, CancellationToken cancellationToken) { return await _Update_SettingJobs.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_SettingJobs(Delete_SettingJobs.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_SettingJobs.Execute(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_SettingJobs.Outputs>>> Get_SettingJobs(Get_SettingJobs.Inputs inputs, CancellationToken cancellationToken) { return await _Get_SettingJobs.Query(inputs, cancellationToken); }
    }
}
