﻿using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.dbo
{
    public class SettingServerContext: ISettingServerContext
    {
        private readonly DP.DapperORM.BaseSP<Get_Setting_Server.Inputs, Get_Setting_Server.Outputs> _Get_Setting_Server;
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        public SettingServerContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Get_Setting_Server = new DP.DapperORM.BaseSP<Get_Setting_Server.Inputs, Get_Setting_Server.Outputs>("dbo.Get_Setting_Server", executer);
        }
        public async Task<DBResult<Get_Setting_Server.Outputs>> Get_Setting_Server(Get_Setting_Server.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Setting_Server.Single(inputs, cancellationToken); }
    }
}
