﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.staticData;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.dbo
{
    public class StaticContext:IStaticContext
    {
        private readonly DP.DapperORM.BaseSP<Get_Static.Inputs, Get_Static.Outputs> _Get_Static;
        private readonly DP.DapperORM.BaseSP<Get_StaticById.Inputs, Get_StaticById.Outputs> _Get_StaticById;
        private readonly DP.DapperORM.BaseSP<Get_Static_Parent.Inputs, Get_Static_Parent.Outputs> _Get_Static_Parent;
        private readonly DP.DapperORM.BaseSP<Insert_Static.Inputs, Insert_Static.Outputs> _Insert_Static;
        private readonly DP.DapperORM.BaseSP<Delete_Static.Inputs, Delete_Static.Outputs> _Delete_Static;
        private readonly DP.DapperORM.BaseSP<GetStatic.Inputs, GetStatic.Outputs> _GetStatic;
        private readonly DP.DapperORM.BaseSP<Update_Static.Inputs, Update_Static.Outputs> _Update_Static;
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        public StaticContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Get_Static = new DP.DapperORM.BaseSP<Get_Static.Inputs, Get_Static.Outputs>("dbo.Get_Static", executer);
            _Get_StaticById = new DP.DapperORM.BaseSP<Get_StaticById.Inputs, Get_StaticById.Outputs>("dbo.Get_StaticById", executer);
            _Get_Static_Parent = new DP.DapperORM.BaseSP<Get_Static_Parent.Inputs, Get_Static_Parent.Outputs>("dbo.Get_Static_Parent", executer);
            _Insert_Static = new DP.DapperORM.BaseSP<Insert_Static.Inputs, Insert_Static.Outputs>("dbo.Insert_Static", executer);
            _Delete_Static = new DP.DapperORM.BaseSP<Delete_Static.Inputs, Delete_Static.Outputs>("dbo.Delete_Static", executer);
            _GetStatic = new DP.DapperORM.BaseSP<GetStatic.Inputs, GetStatic.Outputs>("dbo.GetStatic", executer);
            _Update_Static = new DP.DapperORM.BaseSP<Update_Static.Inputs, Update_Static.Outputs>("dbo.Update_Static", executer);
        }

        public async Task<DBResult<IEnumerable<GetStatic.Outputs>>> GetStatic(GetStatic.Inputs inputs, CancellationToken cancellationToken) { return await _GetStatic.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Static.Outputs>>> Get_Static(Get_Static.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Static.Query(inputs, cancellationToken); }
        public async Task<DBResult<Get_StaticById.Outputs>> Get_StaticById(Get_StaticById.Inputs inputs, CancellationToken cancellationToken) { return await _Get_StaticById.Single(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_Static_Parent.Outputs>>> Get_Static_Parent(Get_Static_Parent.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Static_Parent.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Static(Insert_Static.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Static.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_Static(Update_Static.Inputs inputs, CancellationToken cancellationToken) { return await _Update_Static.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Static(Delete_Static.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Static.Execute(inputs, cancellationToken); }
    }
}
