﻿using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.tag;
using Farakonesh.Models.Database;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.supportPhones;

namespace Farakonesh.Logic.Database.dbo
{
    public class SupportPhonesContext: ISupportPhonesContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_SupportPhones.Inputs, Insert_SupportPhones.Outputs> _Insert_SupportPhones;
        private readonly DP.DapperORM.BaseSP<Update_SupportPhones.Inputs, Update_SupportPhones.Outputs> _Update_SupportPhones;
        private readonly DP.DapperORM.BaseSP<Delete_SupportPhones.Inputs, Delete_SupportPhones.Outputs> _Delete_SupportPhones;
        private readonly DP.DapperORM.BaseSP<Get_SupportPhones.Inputs, Get_SupportPhones.Outputs> _Get_SupportPhones;
        private readonly DP.DapperORM.BaseSP<Get_SupportPhonesByAdmin.Inputs, Get_SupportPhonesByAdmin.Outputs> _Get_SupportPhonesByAdmin;
        public SupportPhonesContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Insert_SupportPhones = new DP.DapperORM.BaseSP<Insert_SupportPhones.Inputs, Insert_SupportPhones.Outputs>("dbo.Insert_SupportPhones", executer);
            _Delete_SupportPhones = new DP.DapperORM.BaseSP<Delete_SupportPhones.Inputs, Delete_SupportPhones.Outputs>("dbo.Delete_SupportPhones", executer);
            _Update_SupportPhones = new DP.DapperORM.BaseSP<Update_SupportPhones.Inputs, Update_SupportPhones.Outputs>("dbo.Update_SupportPhones", executer);
            _Get_SupportPhones = new DP.DapperORM.BaseSP<Get_SupportPhones.Inputs, Get_SupportPhones.Outputs>("dbo.Get_SupportPhones", executer);
            _Get_SupportPhonesByAdmin = new DP.DapperORM.BaseSP<Get_SupportPhonesByAdmin.Inputs, Get_SupportPhonesByAdmin.Outputs>("dbo.Get_SupportPhonesByAdmin", executer);

        }
        public async Task<DBResult<IEnumerable<Get_SupportPhonesByAdmin.Outputs>>> Get_SupportPhonesByAdmin(Get_SupportPhonesByAdmin.Inputs inputs, CancellationToken cancellationToken) { return await _Get_SupportPhonesByAdmin.Query(inputs, cancellationToken); }
        public async Task<DBResult<IEnumerable<Get_SupportPhones.Outputs>>> Get_SupportPhones(Get_SupportPhones.Inputs inputs, CancellationToken cancellationToken) { return await _Get_SupportPhones.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_SupportPhones(Insert_SupportPhones.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_SupportPhones.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_SupportPhones(Update_SupportPhones.Inputs inputs, CancellationToken cancellationToken) { return await _Update_SupportPhones.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_SupportPhones(Delete_SupportPhones.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_SupportPhones.Execute(inputs, cancellationToken); }
    }
}
