﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.ISecurity;
using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.tag;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.Database.dbo
{
    public class TagContext: ITagContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_Tag_Menus.Inputs, Insert_Tag_Menus.Outputs> _Insert_Tag_Menus;
        private readonly DP.DapperORM.BaseSP<Delete_Tag.Inputs, Delete_Tag.Outputs> _Delete_Tag;
        private readonly DP.DapperORM.BaseSP<Get_Tag.Inputs, Get_Tag.Outputs> _Get_Tag;
        private readonly DP.DapperORM.BaseSP<Insert_Tag_MenusGroup.Inputs, Insert_Tag_MenusGroup.Outputs> _Insert_Tag_MenusGroup;
        public TagContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Insert_Tag_Menus = new DP.DapperORM.BaseSP<Insert_Tag_Menus.Inputs, Insert_Tag_Menus.Outputs>("dbo.Insert_Tag_Menus", executer);
            _Delete_Tag = new DP.DapperORM.BaseSP<Delete_Tag.Inputs, Delete_Tag.Outputs>("dbo.Delete_Tag", executer);
            _Get_Tag = new DP.DapperORM.BaseSP<Get_Tag.Inputs, Get_Tag.Outputs>("dbo.Get_Tag", executer);
            _Insert_Tag_MenusGroup = new DP.DapperORM.BaseSP<Insert_Tag_MenusGroup.Inputs, Insert_Tag_MenusGroup.Outputs>("dbo.Insert_Tag_MenusGroup", executer);

        }
        public async Task<DBResult<IEnumerable<Get_Tag.Outputs>>> Get_Tag(Get_Tag.Inputs inputs, CancellationToken cancellationToken) { return await _Get_Tag.Query(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Tag_Menus(Insert_Tag_Menus.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Tag_Menus.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_Tag(Delete_Tag.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_Tag.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Insert_Tag_MenusGroup(Insert_Tag_MenusGroup.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_Tag_MenusGroup.Execute(inputs, cancellationToken); }
    }
}
