﻿using Farakonesh.Models.Database.StoredProcedures.App.dbo.tag;
using Farakonesh.Models.Database;
using Microsoft.Extensions.Configuration;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using Farakonesh.Models.Database.StoredProcedures.App.User.Authentication;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.versionHistory;
using Farakonesh.Logic.IDatabase.idbo;

namespace Farakonesh.Logic.Database.dbo
{
    public class VersionContext: IVersionContext
    {
        #region properties
        private string _connectionString { get; set; }

        #endregion properties

        private readonly DP.DapperORM.BaseSP<Insert_VersionHistory.Inputs, Insert_VersionHistory.Outputs> _Insert_VersionHistory;
        private readonly DP.DapperORM.BaseSP<Delete_VersionHistory.Inputs, Delete_VersionHistory.Outputs> _Delete_VersionHistory;
        private readonly DP.DapperORM.BaseSP<Get_VersionHistory.Inputs, Get_VersionHistory.Outputs> _Get_VersionHistory;
        private readonly DP.DapperORM.BaseSP<Update_VersionHistory.Inputs, Update_VersionHistory.Outputs> _Update_VersionHistory;
        public VersionContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cns");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);
            _Insert_VersionHistory = new DP.DapperORM.BaseSP<Insert_VersionHistory.Inputs, Insert_VersionHistory.Outputs>("dbo.Insert_VersionHistory", executer);
            _Delete_VersionHistory = new DP.DapperORM.BaseSP<Delete_VersionHistory.Inputs, Delete_VersionHistory.Outputs>("dbo.Delete_VersionHistory", executer);
            _Get_VersionHistory = new DP.DapperORM.BaseSP<Get_VersionHistory.Inputs, Get_VersionHistory.Outputs>("dbo.Get_VersionHistory", executer);
            _Update_VersionHistory = new DP.DapperORM.BaseSP<Update_VersionHistory.Inputs, Update_VersionHistory.Outputs>("dbo.Update_VersionHistory", executer);

        }
        public async Task<DBResult<IEnumerable<Get_VersionHistory.Outputs>>> Get_VersionHistory(Get_VersionHistory.Inputs inputs, CancellationToken cancellationToken) { return await _Get_VersionHistory.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult> Insert_VersionHistory(Insert_VersionHistory.Inputs inputs, CancellationToken cancellationToken) { return await _Insert_VersionHistory.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Delete_VersionHistory(Delete_VersionHistory.Inputs inputs, CancellationToken cancellationToken) { return await _Delete_VersionHistory.Execute(inputs, cancellationToken); }
        public async Task<DBResult> Update_VersionHistory(Update_VersionHistory.Inputs inputs, CancellationToken cancellationToken) { return await _Update_VersionHistory.Execute(inputs, cancellationToken); }
    }
}
