﻿using Microsoft.Extensions.Configuration;
using Farakonesh.Logic.IDatabaseLog;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.LogServer;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.DatabaseLog
{
    public class LogContext : ILogContext
    {
        private readonly DP.DapperORM.BaseSP<SP_Log_GetAll.Inputs, SP_Log_GetAll.Outputs> _SP_Log_GetAll;
        private readonly DP.DapperORM.BaseSP<SP_Log_Count.Inputs, SP_Log_Count.Outputs> _SP_Log_Count;

        #region properties
        private string _connectionString { get; set; }

        #endregion properties
        public LogContext(IConfiguration configuration)
        {
            _connectionString = configuration.GetConnectionString("cnsLogServer");
            var executer = new DP.DapperORM.SqlExecuter(_connectionString);

            _SP_Log_GetAll = new DP.DapperORM.BaseSP<SP_Log_GetAll.Inputs, SP_Log_GetAll.Outputs>("dbo.SP_Log_GetAll", executer);
            _SP_Log_Count = new DP.DapperORM.BaseSP<SP_Log_Count.Inputs, SP_Log_Count.Outputs>("dbo.SP_Log_Count", executer);
        }

        public async Task<DBResult<IEnumerable<SP_Log_GetAll.Outputs>>> SP_Log_GetAll(SP_Log_GetAll.Inputs inputs, CancellationToken cancellationToken) { return await _SP_Log_GetAll.QueryPagination(inputs, cancellationToken); }
        public async Task<DBResult<SP_Log_Count.Outputs>> SP_Log_Count(SP_Log_Count.Inputs inputs, CancellationToken cancellationToken) { return await _SP_Log_Count.Single(inputs, cancellationToken); }
    }
}
