﻿using RestSharp;
using Farakonesh.Logic.Log;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
namespace Farakonesh.Logic.ICommonOperations
{
    public interface IRestRequestHelper
    {
        Task<RestResponse<T>> executeAsyncDelete<T>(string action, Dictionary<string, object> parameters
 , CancellationToken cancellationToken, Dictionary<string, string> headers = null);
        Task<RestResponse<T>> executeAsync<T>(string action, object body
            , Method method, CancellationToken cancellationToken, Dictionary<string, string> headers = null);
        Task<RestResponse<T>> executeAsyncMultiPart<T>(string baseUrl, string api, string url
           , Method method, CancellationToken cancellationToken, Dictionary<string, string> headers = null);
        Task<RestResponse<T>> executeAsyncGet<T>(string action, Dictionary<string, string> parameters
        , CancellationToken cancellationToken, Dictionary<string, string> headers = null);
        Task<RestResponse<T>> executeAsyncGet<T>(string action, Dictionary<string, object> parameters
     , CancellationToken cancellationToken, Dictionary<string, string> headers = null);
        Task<RestResponse<T>> executeGraphqlAsync<T>(string action, string body
       , CancellationToken cancellationToken, Dictionary<string, string> headers = null);
    }
}
