﻿using Farakonesh.Models.Database.StoredProcedures.App.BlockChain.Currency;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;

namespace Farakonesh.Logic.IDatabase.IBlockChain
{
    public interface ICurrencyBlockChainContext
    {
        Task<DBResult<Get_CurrencyPriceByOrder.Outputs>> Get_CurrencyPriceByOrder(Get_CurrencyPriceByOrder.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_Currency.Outputs>>> Get_Currency(Get_Currency.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Currency(Insert_Currency.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Currency(Update_Currency.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Currency(Delete_Currency.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_CurrencyAmount.Outputs>>> Get_CurrencyAmount(Get_CurrencyAmount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CurrencyAmount(Insert_CurrencyAmount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_CurrencyByCustomer.Outputs>>> Get_CurrencyByCustomer(Get_CurrencyByCustomer.Inputs inputs, CancellationToken cancellationToken);
    }
}
