﻿using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.AccountNumber;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IOrder
{
    public interface IAccountNumberContext
    {
        Task<DBResult<IEnumerable<GetAccountNumberHistory.Outputs>>> GetAccountNumberHistory(GetAccountNumberHistory.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> InsertAccountNumber(InsertAccountNumber.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> UpdateAccountNumber(UpdateAccountNumber.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_AccountNumber(Delete_AccountNumber.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetAccountNumberActive.Outputs>> GetAccountNumberActive(GetAccountNumberActive.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetAccountNumberByAdmin.Outputs>>> GetAccountNumberByAdmin(GetAccountNumberByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> InsertAccountNumberGroup(InsertAccountNumberGroup.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> UpdateAccountNumberGroup(UpdateAccountNumberGroup.Inputs inputs, CancellationToken cancellationToken);
    }
}
