﻿using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IOrder
{
    public interface ICurrencyContext
    {
        Task<DBResult> Insert_CurrencyRates(Insert_CurrencyRates.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCurrencyListByCustomer.Outputs>>> GetCurrencyListByCustomer(GetCurrencyListByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_MinAmountForChange(Update_MinAmountForChange.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CurrencyIndicator_Automatic(Insert_CurrencyIndicator_Automatic.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_CurrencyPecentSetting.Outputs>>> Get_CurrencyPecentSetting(Get_CurrencyPecentSetting.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CurrencyPercentSetting(Insert_CurrencyPercentSetting.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_CurrencyPercentSetting(Update_CurrencyPercentSetting.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_CurrencyPecentSetting(Delete_CurrencyPecentSetting.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Currency(Update_Currency.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CurrencyAmountGroup(Insert_CurrencyAmountGroup.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCurrencyList_Servant.Outputs>>> GetCurrencyList_Servant(GetCurrencyList_Servant.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCurrencyAmountList_Servant.Outputs>>> GetCurrencyAmountList_Servant(GetCurrencyAmountList_Servant.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Currency_Main(Insert_Currency_Main.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCurrencyAmountListByCustomer.Outputs>>> GetCurrencyAmountListByCustomer(GetCurrencyAmountListByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Appointment_Currency.Outputs>> Appointment_Currency(Appointment_Currency.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCurrency.Outputs>>> GetCurrency(GetCurrency.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_CurrencyOrder(Delete_CurrencyOrder.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_CurrencyShow(Update_CurrencyShow.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCurrencyAmountListByAdmin.Outputs>>> GetCurrencyAmountListByAdmin(GetCurrencyAmountListByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_CurrencyPercentageOfImpact(Update_CurrencyPercentageOfImpact.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Currency(Delete_Currency.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetCurrencyAmountById.Outputs>> GetCurrencyAmountById(GetCurrencyAmountById.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCurrencyAmountList.Outputs>>> GetCurrencyAmountList(GetCurrencyAmountList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetCurrencyById.Outputs>> GetCurrencyById(GetCurrencyById.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCurrencyList.Outputs>>> GetCurrencyList(GetCurrencyList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Currency(Insert_Currency.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CurrencyAmount(Insert_CurrencyAmount.Inputs inputs, CancellationToken cancellationToken);

    }
}
