﻿using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Currency;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Wage;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IOrder
{
    public interface ICurrencyWageContext
    {
        Task<DBResult> Insert_CurrencyWage_FullGroupSave(Insert_CurrencyWage_FullGroupSave.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Wages(Insert_Wages.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetWagesList.Outputs>>> GetWagesList(GetWagesList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCurrencyWageList.Outputs>>> GetCurrencyWageList(GetCurrencyWageList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CurrencyWage(Insert_CurrencyWage.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_CurrencyWage(Update_CurrencyWage.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_CurrencyWage(Delete_CurrencyWage.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CurrencyWageGroup(Insert_CurrencyWageGroup.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CurrencyWageGroupStair(Insert_CurrencyWageGroupStair.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_CurrencyWageGroup(Update_CurrencyWageGroup.Inputs inputs, CancellationToken cancellationToken);
    }
}
