﻿using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.GiftCard;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IOrder
{
    public interface IGiftCardContext
    {
        Task<DBResult<IEnumerable<Get_GiftCardReadySale_Admin.Outputs>>> Get_GiftCardReadySale_Admin(Get_GiftCardReadySale_Admin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_GiftCardReady(Insert_GiftCardReady.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_GiftCardReady(Update_GiftCardReady.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_GiftCardReady(Delete_GiftCardReady.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetGiftCardTypeCountryList.Outputs>>> GetGiftCardTypeCountryList(GetGiftCardTypeCountryList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderGiftCardByAdmin.Outputs>> Insert_OrderGiftCardByAdmin(Insert_OrderGiftCardByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderGiftCardByCustomer.Outputs>> Insert_OrderGiftCardByCustomer(Insert_OrderGiftCardByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_GiftCard.Outputs>>> GetOrder_GiftCard(GetOrder_GiftCard.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_GiftCardByAdmin.Outputs>>> GetOrder_GiftCardByAdmin(GetOrder_GiftCardByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_OrderGiftCard_Price.Outputs>> Get_OrderGiftCard_Price(Get_OrderGiftCard_Price.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetGiftCardTypeList.Outputs>>> GetGiftCardTypeList(GetGiftCardTypeList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_GiftCardType(Delete_GiftCardType.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> InsertGiftCardType(InsertGiftCardType.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> UpdateGiftCardType(UpdateGiftCardType.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetGiftCardTypeListByAdmin.Outputs>>> GetGiftCardTypeListByAdmin(GetGiftCardTypeListByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetGiftCardTypeById.Outputs>>> GetGiftCardTypeById(GetGiftCardTypeById.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GiftCardReady_Spend.Outputs>> GiftCardReady_Spend(GiftCardReady_Spend.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderGiftCardByCompany.Outputs>> Insert_OrderGiftCardByCompany(Insert_OrderGiftCardByCompany.Inputs inputs, CancellationToken cancellationToken);

    }
}
