﻿using Farakonesh.Logic.IDatabase.idbo;
using Farakonesh.Logic.Security;
using Farakonesh.Logic.Services.Cache;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.ApplicationFee;
using Farakonesh.Models.Database.StoredProcedures.App.Order.GiftCard;
using Farakonesh.Models.Database.StoredProcedures.App.Order.Orders;
using System.Collections;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IOrder
{
    public interface IOrderContext
    {
        Task<DBResult<GetFullOrder.Outputs>> GetFullOrder(GetFullOrder.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetCurrencyWareHouse_FinancialByOrder_Sum.Outputs>> GetCurrencyWareHouse_FinancialByOrder_Sum(GetCurrencyWareHouse_FinancialByOrder_Sum.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_Discount_OrderType_Servant.Outputs>> Get_Discount_OrderType_Servant(Get_Discount_OrderType_Servant.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrders_Search.Outputs>>> GetOrders_Search(GetOrders_Search.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_Order_Status.Outputs>> Update_Order_Status(Update_Order_Status.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_Order_Status_ExpireDate_Cancel.Outputs>> Update_Order_Status_ExpireDate_Cancel(Update_Order_Status_ExpireDate_Cancel.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_Order_Status_WithouToken.Outputs>> Update_Order_Status_WithouToken(Update_Order_Status_WithouToken.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_Order_Status_ByAdmin.Outputs>> Update_Order_Status_ByAdmin(Update_Order_Status_ByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetOrderById.Outputs>> GetOrderById(GetOrderById.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrdersCompeletedAdmin_Financial_Sell.Outputs>>> GetOrdersCompeletedAdmin_Financial_Sell(GetOrdersCompeletedAdmin_Financial_Sell.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrders.Outputs>>> GetOrders(GetOrders.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrdersAdmin.Outputs>>> GetOrdersAdmin(GetOrdersAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetOrdersAdminById.Outputs>> GetOrdersAdminById(GetOrdersAdminById.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrdersCompeletedAdmin_Export.Outputs>>> GetOrdersCompeletedAdmin_Export(GetOrdersCompeletedAdmin_Export.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetOrderById_Print.Outputs>> GetOrderById_Print(GetOrderById_Print.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrdersAdmin_Export.Outputs>>> GetOrdersAdmin_Export(GetOrdersAdmin_Export.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_Wallet_Company_ByCommission.Outputs>> Update_Wallet_Company_ByCommission(Update_Wallet_Company_ByCommission.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult<IEnumerable<GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse.Outputs>>> GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse(GetOrdersCompeletedAdmin_FinancialByCurrencyWareHouse.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_Order_Status.Outputs>> Update_Order_Status_Cancel(Update_Order_Status.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult> Insert_OrderDocumentsByCustomer(Insert_OrderDocumentsByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrderDocumentsAdmin.Outputs>>> GetOrderDocumentsAdmin(GetOrderDocumentsAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrderDocuments.Outputs>>> GetOrderDocuments(GetOrderDocuments.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult<GetOrderByIdWithoutToken.Outputs>> GetOrderByIdWithoutToken(GetOrderByIdWithoutToken.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult<IEnumerable<GetOrdersCompeletedAdmin.Outputs>>> GetOrdersCompeletedAdmin(GetOrdersCompeletedAdmin.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult> Update_Order_Finance(Update_Order_Finance.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult<IEnumerable<GetHistoryOrder.Outputs>>> GetHistoryOrder(GetHistoryOrder.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrdersCompeletedAdmin_Financial.Outputs>>> GetOrdersCompeletedAdmin_Financial(GetOrdersCompeletedAdmin_Financial.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult<IEnumerable<GetStatus_Step_Order.Outputs>>> GetStatus_Step_Order(GetStatus_Step_Order.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult<Update_Order_Receipt.Outputs>> Update_Order_Receipt(Update_Order_Receipt.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Order(Update_Order.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult> Delete_Order(Delete_Order.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Show_Order_Company_Commission.Outputs>> Show_Order_Company_Commission(Show_Order_Company_Commission.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCurrencyWareHouse_FinancialByOrder.Outputs>>> GetCurrencyWareHouse_FinancialByOrder(GetCurrencyWareHouse_FinancialByOrder.Inputs inputs, CancellationToken cancellationToken);
    }
}
