﻿using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PerfectMoney;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IOrder
{
    public interface IPerfectMoneyContext
    {
        Task<DBResult<Get_OrderPerfectMoneyCharge_Price_Servant.Outputs>> Get_OrderPerfectMoneyCharge_Price_Servant(Get_OrderPerfectMoneyCharge_Price_Servant.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_OrderPerfectMoneySell_Price_Servant.Outputs>> Get_OrderPerfectMoneySell_Price_Servant(Get_OrderPerfectMoneySell_Price_Servant.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_OrderPerfectMoneyVoucher_Price_Servant.Outputs>> Get_OrderPerfectMoneyVoucher_Price_Servant(Get_OrderPerfectMoneyVoucher_Price_Servant.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPerfectMoneyChargeByAdmin.Outputs>> Insert_OrderPerfectMoneyChargeByAdmin(Insert_OrderPerfectMoneyChargeByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPerfectMoneySellByAdmin.Outputs>> Insert_OrderPerfectMoneySellByAdmin(Insert_OrderPerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPerfectMoneyVoucherByAdmin.Outputs>> Insert_OrderPerfectMoneyVoucherByAdmin(Insert_OrderPerfectMoneyVoucherByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderVoucherPerfectMoneySellByAdmin.Outputs>> Insert_OrderVoucherPerfectMoneySellByAdmin(Insert_OrderVoucherPerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult<Get_OrderPerfectMoneyCharge_Price.Outputs>> Get_OrderPerfectMoneyCharge_Price(Get_OrderPerfectMoneyCharge_Price.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_OrderPerfectMoneyVoucher_Price.Outputs>> Get_OrderPerfectMoneyVoucher_Price(Get_OrderPerfectMoneyVoucher_Price.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPerfectMoneyChargeByCustomer.Outputs>> Insert_OrderPerfectMoneyChargeByCustomer(Insert_OrderPerfectMoneyChargeByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPerfectMoneyVoucherByCustomer.Outputs>> Insert_OrderPerfectMoneyVoucherByCustomer(Insert_OrderPerfectMoneyVoucherByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_PerfectMoneyCharge.Outputs>>> GetOrder_PerfectMoneyCharge(GetOrder_PerfectMoneyCharge.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_PerfectMoneyVoucher.Outputs>>> GetOrder_PerfectMoneyVoucher(GetOrder_PerfectMoneyVoucher.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_PerfectMoneyVoucherByAdmin.Outputs>>> GetOrder_PerfectMoneyVoucherByAdmin(GetOrder_PerfectMoneyVoucherByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_PerfectMoneyChargeByAdmin.Outputs>>> GetOrder_PerfectMoneyChargeByAdmin(GetOrder_PerfectMoneyChargeByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_OrderPerfectMoneyVoucherByCustomer(Update_OrderPerfectMoneyVoucherByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_OrderPerfectMoneyByCustomer(Update_OrderPerfectMoneyByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetOrder_PerfectMoneyChargeAnonymous.Outputs>> GetOrder_PerfectMoneyChargeAnonymous(GetOrder_PerfectMoneyChargeAnonymous.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetOrder_PerfectMoneyVoucherAnonymous.Outputs>> GetOrder_PerfectMoneyVoucherAnonymous(GetOrder_PerfectMoneyVoucherAnonymous.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult<Insert_OrderPerfectMoneySellByCustomer.Outputs>> Insert_OrderPerfectMoneySellByCustomer(Insert_OrderPerfectMoneySellByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_PerfectMoneySell.Outputs>>> GetOrder_PerfectMoneySell(GetOrder_PerfectMoneySell.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetOrder_PerfectMoneySellAnonymous.Outputs>> GetOrder_PerfectMoneySellAnonymous(GetOrder_PerfectMoneySellAnonymous.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_PerfectMoneySellByAdmin.Outputs>>> GetOrder_PerfectMoneySellByAdmin(GetOrder_PerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_OrderPerfectMoneySell_Price.Outputs>> Get_OrderPerfectMoneySell_Price(Get_OrderPerfectMoneySell_Price.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_OrderPerfectMoneySellByCustomer.Outputs>> Update_OrderPerfectMoneySellByCustomer(Update_OrderPerfectMoneySellByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderVoucherPerfectMoneySellByCustomer.Outputs>> Insert_OrderVoucherPerfectMoneySellByCustomer(Insert_OrderVoucherPerfectMoneySellByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_OrderVoucherPerfectMoneySellByCustomer.Outputs>> Update_OrderVoucherPerfectMoneySellByCustomer(Update_OrderVoucherPerfectMoneySellByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_OrderVoucherPerfectMoneySell_Price.Outputs>> Get_OrderVoucherPerfectMoneySell_Price(Get_OrderVoucherPerfectMoneySell_Price.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_VoucherPerfectMoneySell.Outputs>>> GetOrder_VoucherPerfectMoneySell(GetOrder_VoucherPerfectMoneySell.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_VoucherPerfectMoneySellByAdmin.Outputs>>> GetOrder_VoucherPerfectMoneySellByAdmin(GetOrder_VoucherPerfectMoneySellByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetOrder_PerfectMoneyVoucherSellAnonymous.Outputs>> GetOrder_PerfectMoneyVoucherSellAnonymous(GetOrder_PerfectMoneyVoucherSellAnonymous.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPerfectMoneySellByCompany.Outputs>> Insert_OrderPerfectMoneySellByCompany(Insert_OrderPerfectMoneySellByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPerfectMoneyChargeByCompany.Outputs>> Insert_OrderPerfectMoneyChargeByCompany(Insert_OrderPerfectMoneyChargeByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPerfectMoneyVoucherByCompany.Outputs>> Insert_OrderPerfectMoneyVoucherByCompany(Insert_OrderPerfectMoneyVoucherByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderVoucherPerfectMoneySellByCompany.Outputs>> Insert_OrderVoucherPerfectMoneySellByCompany(Insert_OrderVoucherPerfectMoneySellByCompany.Inputs inputs, CancellationToken cancellationToken);
    }
}
