﻿using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order.PremiumAccount;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IOrder
{
    public interface IPremiumAccountContext
    {
        Task<DBResult<GetFullPremiumAccount.Outputs>> GetFullPremiumAccount(GetFullPremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_ActivationTypePremiumAccount(Delete_ActivationTypePremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_CountryPremiumAccount(Delete_CountryPremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_LanguagePremiumAccount(Delete_LanguagePremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_PelanPremiumAccount(Delete_PelanPremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_PeriodPremiumAccount(Delete_PeriodPremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_TypePremiumAccount(Delete_TypePremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_ActivationTypePremiumAccount(Insert_ActivationTypePremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CountryPremiumAccount(Insert_CountryPremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_LanguagePremiumAccount(Insert_LanguagePremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_PelanPremiumAccount(Insert_PelanPremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_PeriodPremiumAccount(Insert_PeriodPremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_TypePremiumAccount(Insert_TypePremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPremiumAccountByCustomer.Outputs>> Insert_OrderPremiumAccountByCustomer(Insert_OrderPremiumAccountByCustomer.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult> Update_ActivationTypePremiumAccount(Update_ActivationTypePremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_CountryPremiumAccount(Update_CountryPremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_LanguagePremiumAccount(Update_LanguagePremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_PelanPremiumAccount(Update_PelanPremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_PeriodPremiumAccount(Update_PeriodPremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_TypePremiumAccount(Update_TypePremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetActivationTypePremiumAccountList.Outputs>>> GetActivationTypePremiumAccountList(GetActivationTypePremiumAccountList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCountryPremiumAccountList.Outputs>>> GetCountryPremiumAccountList(GetCountryPremiumAccountList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetLanguagePremiumAccountList.Outputs>>> GetLanguagePremiumAccountList(GetLanguagePremiumAccountList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetPelanPremiumAccountList.Outputs>>> GetPelanPremiumAccountList(GetPelanPremiumAccountList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetPeriodPremiumAccountList.Outputs>>> GetPeriodPremiumAccountList(GetPeriodPremiumAccountList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetTypePremiumAccountList.Outputs>>> GetTypePremiumAccountList(GetTypePremiumAccountList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_OrderPremiumAccount_Price.Outputs>> Get_OrderPremiumAccount_Price(Get_OrderPremiumAccount_Price.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_PremiumAccount.Outputs>>> GetOrder_PremiumAccount(GetOrder_PremiumAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetOrder_PremiumAccountByAdmin.Outputs>>> GetOrder_PremiumAccountByAdmin(GetOrder_PremiumAccountByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPremiumAccountByAdmin.Outputs>> Insert_OrderPremiumAccountByAdmin(Insert_OrderPremiumAccountByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_OrderPremiumAccountByCompany.Outputs>> Insert_OrderPremiumAccountByCompany(Insert_OrderPremiumAccountByCompany.Inputs inputs, CancellationToken cancellationToken);
    }
}
