﻿using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Order;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IOrder
{
    public interface IRamRegionServerContext
    {

        Task<DBResult<IEnumerable<GetRamServer.Outputs>>> GetRamServer(GetRamServer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetPeriodServer.Outputs>>> GetPeriodServer(GetPeriodServer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetRegionServer.Outputs>>> GetRegionServer(GetRegionServer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_ServerPeriod(Insert_ServerPeriod.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_ServerRam(Insert_ServerRam.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_ServerRegion(Insert_ServerRegion.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_ServerPeriod(Update_ServerPeriod.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_ServerRam(Update_ServerRam.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_ServerRegion(Update_ServerRegion.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_ServerPeriod(Delete_ServerPeriod.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_ServerRam(Delete_ServerRam.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_ServerRegion(Delete_ServerRegion.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetRegionServerByRamId.Outputs>>> GetRegionServerByRamId(GetRegionServerByRamId.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_ServerRegionRam(Delete_ServerRegionRam.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_ServerRegionRam(Insert_ServerRegionRam.Inputs inputs, CancellationToken cancellationToken);
    }
}
