﻿using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Queue;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IQueue
{
    public interface IQueueContext
    {
        Task<DBResult<IEnumerable<Get_Payment.Outputs>>> Get_Payment(Get_Payment.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_TelegramBotChannelConnectionAction.Outputs>>> Get_TelegramBotChannelConnectionAction(Get_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_TelegramBotChannelConnectionAction_WithoutToken.Outputs>>> Get_TelegramBotChannelConnectionAction_WithoutToken(Get_TelegramBotChannelConnectionAction_WithoutToken.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_TelegramBotChannelConnectionAction(Insert_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_TelegramBotChannelConnectionAction(Update_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_TelegramBotChannelConnectionAction(Delete_TelegramBotChannelConnectionAction.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_TelegramBotChannel(Insert_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_TelegramBotChannelByHook(Insert_TelegramBotChannelByHook.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_TelegramBotChannel(Update_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_TelegramBotChannel(Delete_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_TelegramBotChannel.Outputs>>> Get_TelegramBotChannel(Get_TelegramBotChannel.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_MessengersByHook.Outputs>> Insert_MessengersByHook(Insert_MessengersByHook.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Disconnect_To_MessengersByCustomer(Disconnect_To_MessengersByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_TelegramState(Update_TelegramState.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_TelegramState.Outputs>> Get_TelegramState(Get_TelegramState.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Connect_To_MessengersByCustomer(Update_Connect_To_MessengersByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_Calendar.Outputs>>> Get_Calendar(Get_Calendar.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_Calendar.Outputs>> Insert_Calendar(Insert_Calendar.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_Sms.Outputs>> Insert_Sms(Insert_Sms.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Sms(Update_Sms.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_Email.Outputs>> Insert_Email(Insert_Email.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Email(Update_Email.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_Token.Outputs>> Insert_Token(Insert_Token.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_Tokens.Outputs>>> Get_Tokens(Get_Tokens.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_Last_Token.Outputs>> Get_Last_Token(Get_Last_Token.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_Alarms.Outputs>>> Get_Alarms(Get_Alarms.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Alarm(Insert_Alarm.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Alarm(Update_Alarm.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Alarm(Delete_Alarm.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Alarm_User(Delete_Alarm_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Insert_Chat.Outputs>>> Insert_Chat(Insert_Chat.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_Chat.Outputs>>> Get_Chat(Get_Chat.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_Emails.Outputs>>> Get_Emails(Get_Emails.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_SMS.Outputs>>> Get_SMS(Get_SMS.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_Messengers.Outputs>>> Get_Messengers(Get_Messengers.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_Messengers.Outputs>> Insert_Messengers(Insert_Messengers.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Messengers(Update_Messengers.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Connect_To_MessengersByCustomer.Outputs>> Connect_To_MessengersByCustomer(Connect_To_MessengersByCustomer.Inputs inputs, CancellationToken cancellationToken);

    }
}
