﻿using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.Report;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IReport
{
    public interface IReportContext
    {
        Task<DBResult<IEnumerable<GetUserRFMCategoryReport.Outputs>>> GetUserRFMCategoryReport(GetUserRFMCategoryReport.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_CurrencyWarehouse_Report_Admin.Outputs>>> Get_CurrencyWarehouse_Report_Admin(Get_CurrencyWarehouse_Report_Admin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_CurrencyWarehouse_Report_Sum_Admin.Outputs>>> Get_CurrencyWarehouse_Report_Sum_Admin(Get_CurrencyWarehouse_Report_Sum_Admin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetSummaryWallet.Outputs>> GetSummaryWallet(GetSummaryWallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetUserReport.Outputs>>> GetUserReport(GetUserReport.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetRfmSummary.Outputs>> GetRfmSummary(GetRfmSummary.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetAccountNumberHistoryReport.Outputs>> GetAccountNumberHistoryReport(GetAccountNumberHistoryReport.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetTransactionReport.Outputs>> GetTransactionReport(GetTransactionReport.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetPaymentLinkHistoryReport.Outputs>> GetPaymentLinkHistoryReport(GetPaymentLinkHistoryReport.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetCountAllDashboard.Outputs>> GetCountAllDashboard(GetCountAllDashboard.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_GeneralReportWarehouse_Admin.Outputs>> Get_GeneralReportWarehouse_Admin(Get_GeneralReportWarehouse_Admin.Inputs inputs, CancellationToken cancellationToken);
    }
}
