﻿using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Address;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IUser
{
    public interface IAddressContext
    {
        Task<DBResult> Delete_AddressByAdmin(Delete_AddressByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_AddressByAdmin(Update_AddressByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_AddressByAdmin(Insert_AddressByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetAddressByAdmin.Outputs>>> GetAddressByAdmin(GetAddressByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetAddress.Outputs>>> GetAddress(GetAddress.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Check_ExistsAddress(Check_ExistsAddress.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Address(Insert_Address.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Address(Update_Address.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Address(Delete_Address.Inputs inputs, CancellationToken cancellationToken);
    }
}
