﻿using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Authentication;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IUser
{
    public interface IAuthenticationContext
    {
        Task<DBResult> Expire_VerifyCode(Expire_VerifyCode.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<LoginWithSocial.Outputs>> LoginWithSocial(LoginWithSocial.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<LoginCompany.Outputs>> LoginCompany(LoginCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_VerifyCodeByCompany.Outputs>> Insert_VerifyCodeByCompany(Insert_VerifyCodeByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<VeriyCode_Register_ByCompany.Outputs>> VeriyCode_Register_ByCompany(VeriyCode_Register_ByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Login.Outputs>> Login(Login.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<RefreshToken.Outputs>> RefreshToken(RefreshToken.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> SignOut(SignOut.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_VerifyCode.Outputs>> Insert_VerifyCode(Insert_VerifyCode.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_VerifyCodeToken.Outputs>> Insert_VerifyCodeToken(Insert_VerifyCodeToken.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<VeriyCode_Login_Register.Outputs>> VeriyCode_Login_Register(VeriyCode_Login_Register.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<VeriyCode_Email_Tel.Outputs>> VeriyCode_Email_Tel(VeriyCode_Email_Tel.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_VerifyCodeByCompany_Old_User.Outputs>> Insert_VerifyCodeByCompany_Old_User(Insert_VerifyCodeByCompany_Old_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Check_VerifyCodeByCompany(Check_VerifyCodeByCompany.Inputs inputs, CancellationToken cancellationToken);
    }
}
