﻿using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IUser
{
    public interface IBankAccountContext
    {
        Task<DBResult> Check_BankAccount_User(Check_BankAccount_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_BankAccountByAdmin(Insert_BankAccountByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_BankAccountByAdmin(Delete_BankAccountByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetBankAccountByAdmin.Outputs>>> GetBankAccountByAdmin(GetBankAccountByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_BankAccount(Insert_BankAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_BankAccount(Delete_BankAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetBankAccount.Outputs>>> GetBankAccount(GetBankAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_BankAccount(Update_BankAccount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_BankAccountByAdmin(Update_BankAccountByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_BankAccount_Set_Default(Update_BankAccount_Set_Default.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_BankAccount_Set_Default_ByAdmin(Update_BankAccount_Set_Default_ByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetBankAccount_WithoutToken.Outputs>>> GetBankAccount_WithoutToken(GetBankAccount_WithoutToken.Inputs inputs, CancellationToken cancellationToken);
    }
}
