﻿using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IUser
{
    public interface ICompanyContext
    {
        Task<DBResult> Check_Duplicate_CompanyClient(Check_Duplicate_CompanyClient.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Company_User(Update_Company_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCompanyList.Outputs>>> GetCompanyList(GetCompanyList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetCompanyById.Outputs>> GetCompanyById(GetCompanyById.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetCompany.Outputs>> GetCompany(GetCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Company(Insert_Company.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Company(Update_Company.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Company(Delete_Company.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Company_User(Delete_Company_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Company_User(Insert_Company_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_Company_User.Outputs>>> Get_Company_User(Get_Company_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCompanyClientList.Outputs>>> GetCompanyClientList(GetCompanyClientList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CompanyClient(Insert_CompanyClient.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_CompanyClient(Delete_CompanyClient.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCompanyListByUserId.Outputs>>> GetCompanyListByUserId(GetCompanyListByUserId.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCompanyClientListByAdmin.Outputs>>> GetCompanyClientListByAdmin(GetCompanyClientListByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_CompanyClientByAdmin(Delete_CompanyClientByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CompanyClientByAdmin(Insert_CompanyClientByAdmin.Inputs inputs, CancellationToken cancellationToken);
    }
}
