﻿using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Company;
using Farakonesh.Models.Database.StoredProcedures.App.User.Discount;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IUser
{
    public interface IDiscountContext
    {
        Task<DBResult<IEnumerable<GetDiscountCode.Outputs>>> GetDiscountCode(GetDiscountCode.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetDiscountByCompany.Outputs>>> GetDiscountByCompany(GetDiscountByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_Discount.Outputs>> Insert_Discount(Insert_Discount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Discount_User(Insert_Discount_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_Discount.Outputs>> Update_Discount(Update_Discount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Discount(Delete_Discount.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Discount_User(Delete_Discount_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_DiscountByCompany(Delete_DiscountByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetDiscountUser.Outputs>>> GetDiscountUser(GetDiscountUser.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Reset_Discount_User(Reset_Discount_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_DiscountByCompany.Outputs>> Insert_DiscountByCompany(Insert_DiscountByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Discount_UserByCompany(Delete_Discount_UserByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetDiscountUserByCompany.Outputs>>> GetDiscountUserByCompany(GetDiscountUserByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Discount_UserByCompany(Insert_Discount_UserByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_DiscountByCompany.Outputs>> Update_DiscountByCompany(Update_DiscountByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetDiscountForAlarmByCompany.Outputs>> GetDiscountForAlarmByCompany(GetDiscountForAlarmByCompany.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Discount_UserByAdmin(Delete_Discount_UserByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Discount_OrderType(Insert_Discount_OrderType.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Discount_OrderType(Update_Discount_OrderType.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Discount_OrderType(Delete_Discount_OrderType.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetDiscount_OrderTypeByAdmin.Outputs>>> GetDiscount_OrderTypeByAdmin(GetDiscount_OrderTypeByAdmin.Inputs inputs, CancellationToken cancellationToken);
    }
}
