﻿using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IUser
{
    public interface IInboxContext
    {
        Task<DBResult<IEnumerable<GetInbox.Outputs>>> GetInbox(GetInbox.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetInboxById.Outputs>> GetInboxById(GetInboxById.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetInboxByAdmin.Outputs>>> GetInboxByAdmin(GetInboxByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_Inbox.Outputs>> Insert_Inbox(Insert_Inbox.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_InboxContent(Insert_InboxContent.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Inbox(Delete_Inbox.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetInboxContent.Outputs>>> GetInboxContent(GetInboxContent.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Seen_Inbox(Update_Seen_Inbox.Inputs inputs, CancellationToken cancellationToken);
    }
}
