﻿using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IUser
{
    public interface ITicketContext
    {
        Task<DBResult<Insert_Ticket_Auto.Outputs>> Insert_Ticket_Auto(Insert_Ticket_Auto.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetTicket.Outputs>>> GetTicket(GetTicket.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetTicketById.Outputs>> GetTicketById(GetTicketById.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetTicketContent.Outputs>>> GetTicketContent(GetTicketContent.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetTicketByAdmin.Outputs>>> GetTicketByAdmin(GetTicketByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Ticket(Insert_Ticket.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_TicketContent.Outputs>> Insert_TicketContent(Insert_TicketContent.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_Ticket_Status.Outputs>> Update_Ticket_Status(Update_Ticket_Status.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetTicketAttachments.Outputs>>> GetTicketAttachments(GetTicketAttachments.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_TicketByAdmin.Outputs>> Insert_TicketByAdmin(Insert_TicketByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Ticket(Delete_Ticket.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetTicketContentByAdmin.Outputs>>> GetTicketContentByAdmin(GetTicketContentByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetTicketReportByAdmin.Outputs>> GetTicketReportByAdmin(GetTicketReportByAdmin.Inputs inputs, CancellationToken cancellationToken);
    }
}
