﻿using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.ActionLog;
using Farakonesh.Models.Database.StoredProcedures.App.User.Address;
using Farakonesh.Models.Database.StoredProcedures.App.User.Authentication;
using Farakonesh.Models.Database.StoredProcedures.App.User.Inbox;
using Farakonesh.Models.Database.StoredProcedures.App.User.Level;
using Farakonesh.Models.Database.StoredProcedures.App.User.Location;
using Farakonesh.Models.Database.StoredProcedures.App.User.Survey;
using Farakonesh.Models.Database.StoredProcedures.App.User.Ticket;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IUser
{
    public interface IUserContext
    {
        Task<DBResult> Check_Duplicate_PostalCode(Check_Duplicate_PostalCode.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_WrongInquiry(Insert_WrongInquiry.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Check_Duplicate_Profile(Check_Duplicate_Profile.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetFullUser.Outputs>> GetFullUser(GetFullUser.Inputs inputs, CancellationToken cancellationToken);

        Task<DBResult<GetUser.Outputs>> GetUser(GetUser.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetUserList.Outputs>>> GetUserList(GetUserList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetUserListSearch.Outputs>>> GetUserListSearch(GetUserListSearch.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Profile(Update_Profile.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Document(Insert_Document.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Password(Update_Password.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetDocuments.Outputs>>> GetDocuments(GetDocuments.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetProvince.Outputs>>> GetProvince(GetProvince.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCity.Outputs>>> GetCity(GetCity.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetUserVerifying.Outputs>>> GetUserVerifying(GetUserVerifying.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetUserVerifyingAll.Outputs>>> GetUserVerifyingAll(GetUserVerifyingAll.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetDocumentsByAdmin.Outputs>>> GetDocumentsByAdmin(GetDocumentsByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<ResendVerifyCode.Outputs>> ResendVerifyCode(ResendVerifyCode.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_User(Delete_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_User.Outputs>> Insert_User(Insert_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_User(Update_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_PasswordByAdmin(Update_PasswordByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Location(Insert_Location.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Location(Update_Location.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Location(Delete_Location.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Profile_Avatar(Update_Profile_Avatar.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Accept_Level_User.Outputs>> Accept_Level_User(Accept_Level_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Document_Accept(Insert_Document_Accept.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetUserByIdAdmin.Outputs>> GetUserByIdAdmin(GetUserByIdAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_User_Role(Update_User_Role.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_Language_User(Update_Language_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetCounts.Outputs>> GetCounts(GetCounts.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetEmailList.Outputs>>> GetEmailList(GetEmailList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetMobileList.Outputs>>> GetMobileList(GetMobileList.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Update_Password_Auto_Generate.Outputs>> Update_Password_Auto_Generate(Update_Password_Auto_Generate.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_User_Active_IsActive(Update_User_Active_IsActive.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_UserVerifying(Insert_UserVerifying.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_UserVerifying(Delete_UserVerifying.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_Setting_User.Outputs>> Get_Setting_User(Get_Setting_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_Setting_User_ByAdmin.Outputs>>> Get_Setting_User_ByAdmin(Get_Setting_User_ByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Setting_User(Insert_Setting_User.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_User_Wallet_Config(Update_User_Wallet_Config.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_Config_User_Wallet.Outputs>> Get_Config_User_Wallet(Get_Config_User_Wallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_Config_User_Wallet_ByCustomer.Outputs>> Get_Config_User_Wallet_ByCustomer(Get_Config_User_Wallet_ByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_Survey(Insert_Survey.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Change_User_LockUpdate(Change_User_LockUpdate.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<Get_ActionLogs.Outputs>>> Get_ActionLogs(Get_ActionLogs.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Reset_User_Password(Reset_User_Password.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_ClientTrackingDataExternal(Insert_ClientTrackingDataExternal.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_ClientTrackingDataExternal.Outputs>> Get_ClientTrackingDataExternal(Get_ClientTrackingDataExternal.Inputs inputs, CancellationToken cancellationToken);
    }
}