﻿using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using Farakonesh.Models.Database.StoredProcedures.App.User.Wallet;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.IUser
{
    public interface IWalletContext
    {
        Task<DBResult<CreateMultiCurrencyWallet.Outputs>> CreateMultiCurrencyWallet(CreateMultiCurrencyWallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetMultiCurrencyWalletByAdmin.Outputs>>> GetMultiCurrencyWalletByAdmin(GetMultiCurrencyWalletByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetMultiCurrencyWalletByCustomer.Outputs>>> GetMultiCurrencyWalletByCustomer(GetMultiCurrencyWalletByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<ConvertPointWalletToWallet.Outputs>> ConvertPointWalletToWallet(ConvertPointWalletToWallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetPointWalletOrderByAdmin.Outputs>>> GetPointWalletOrderByAdmin(GetPointWalletOrderByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_PointWalletOrder(Update_PointWalletOrder.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_PointWalletOrder(Insert_PointWalletOrder.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_PointWalletOrder(Delete_PointWalletOrder.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> CreatePointWalletByCustomer(CreatePointWalletByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetPointWalletByAdmin.Outputs>>> GetPointWalletByAdmin(GetPointWalletByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetPointWallet.Outputs>> GetPointWallet(GetPointWallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<UpdatePointWallet.Outputs>> UpdatePointWallet(UpdatePointWallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> CreatePointWallet(CreatePointWallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<GetWallet.Outputs>> GetWallet(GetWallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetWalletByAdmin.Outputs>>> GetWalletByAdmin(GetWalletByAdmin.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<UpdateWallet.Outputs>> UpdateWallet(UpdateWallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> CreateWallet(CreateWallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Update_User_Setting_Wallet(Update_User_Setting_Wallet.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> CreateWalletByCustomer(CreateWalletByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Insert_CashByCustomer(Insert_CashByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCash.Outputs>>> GetCash(GetCash.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetCashByCustomer.Outputs>>> GetCashByCustomer(GetCashByCustomer.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Change_Status_Cash.Outputs>> Change_Status_Cash(Change_Status_Cash.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Delete_Cash(Delete_Cash.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_CashByAdmin.Outputs>> Insert_CashByAdmin(Insert_CashByAdmin.Inputs inputs, CancellationToken cancellationToken);
    }
}
