﻿using Farakonesh.Logic.Security;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.bank;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.shortLink;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IDatabase.idbo
{
    public interface IPublicContext
    {
        Task<DBResult<GetBankById.Outputs>> GetBankById(GetBankById.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Insert_File.Outputs>> Insert_File(Insert_File.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetBank.Outputs>>> GetBank(GetBank.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_ShortLink.Outputs>> Get_ShortLink(Get_ShortLink.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult> Check_IpAccess(Check_IpAccess.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_Order_Setting.Outputs>> Get_Order_Setting(Get_Order_Setting.Inputs inputs, CancellationToken cancellationToken);
        Task<DBResult<Get_Order_Setting_WithoutToken.Outputs>> Get_Order_Setting_WithoutToken(Get_Order_Setting_WithoutToken.Inputs inputs, CancellationToken cancellationToken);
    }
}
