﻿using Farakonesh.Commands.Services;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Models.API.Nipoto.Creating.Request;
using Farakonesh.Models.API.Nipoto.Creating.Response;
using Farakonesh.Models.API.Nipoto.Request;
using Farakonesh.Models.API.Nipoto.Response;
using Farakonesh.Models.API.Nipoto.Deal.Response;

namespace Farakonesh.Logic.IServices.IApp.ICryptoCurrency
{
    public interface INipotoService
    {
        Task<DBResult<FeeNipotoResponseModel>> getFeeList(GetMarketListNipotoCommand command, CancellationToken cancellationToken, bool checkJobToken = true);
        Task<DBResult<MarketNipotoResponseModel>> getMarketList(GetMarketListNipotoCommand command, CancellationToken cancellationToken, bool checkJobToken = true);
        Task<DBResult> checkPayByDeposit(string depositId, CancellationToken cancellationToken);
        Task<DBResult> checkPay(InfoDepositRequestModel model, CancellationToken cancellationToken);
        Task<DBResult> getPayByDeposit(string depositId, CancellationToken cancellationToken);
        Task<DBResult<List<InfoDepositResponseModel>>> getPayByDepositList(InfoDepositRequestModel model, CancellationToken cancellationToken);
        Task<DBResult> startPay(StartPayOrderByCryptoCurrencyCommand command, CancellationToken cancellationToken);
        Task<DBResult<BalanceResponseNipotoModel>> getBalance(BalanceRequestNipotoModel model, CancellationToken cancellationToken);
    }
}
