﻿using Farakonesh.Commands.Services;
using Farakonesh.Shared.Enums;
using Farakonesh.Models.Database;
using Farakonesh.Models.Database.StoredProcedures.App.dbo.setting;
using Farakonesh.Models.Database.StoredProcedures.App.User.User;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IServices.IApp.IOrder
{
    public interface IAutomaticOrderOperationService
    {
        Task<decimal?> CheckScenario(CheckScenarioCommand command, CancellationToken cancellationToken);
        DBResult getPPGResult(GetDbResultPPGCommand command);
        Task<DBResult> DoCompeleteScenario(DoCompeleteScenarioCommand command, CancellationToken cancellationToken);
        Task<DBResult> doCompelete(DoCompeleteCommand command, CancellationToken cancellationToken);
        Task<DBResult> doCompeleteWalletCharge(DoCompeleteWalletCharge command, CancellationToken cancellationToken);
        Task<DBResult> doCompeleteFreeOrder(DoCompeleteFreeOrderCommand command
            , CancellationToken cancellationToken);
        Task CheckIpClientPortal(CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetBankAccount_WithoutToken.Outputs>>> checkBankAccountClientPortalWithoutToken(CheckBankAccountClientPortalCommand model, CancellationToken cancellationToken);
        Task<DBResult<IEnumerable<GetBankAccount.Outputs>>> checkBankAccountClientPortal(CheckBankAccountClientPortalCommand model, CancellationToken cancellationToken);
    }
}
