﻿using Farakonesh.Commands.Services;
using Farakonesh.Commands.Services.Order;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Threading.Tasks;

namespace Farakonesh.Logic.IServices.IApp.IOrder
{
    public interface IPayeerService
    {
        Task<bool> checkAccountName(string account, CancellationToken cancellationToken);
        Task<DBResult<object>> getCheckAccountName(GetCheckAccountNamePayeerCommand command, CancellationToken cancellationToken);
        Task<DBResult> getAccountBalance(CancellationToken cancellationToken);
        Task<DBResult> updateSellPayeer(UpdateSellPayeerCommand command, CancellationToken cancellationToken);
        Task<DBResult> getRedirectSellPayeer(GetRedirectSellPayeerCommand command, CancellationToken cancellationToken);
        Task<DBResult> getHistory(GetHistoryPayeerCommand command, CancellationToken cancellationToken);
        Task<DBResult> checkAuthAccount(CancellationToken cancellationToken);
        Task<bool> checkAccountBalance(decimal? amount, Guid? CurrencyId, CancellationToken cancellationToken);
        Task<DBResult> transferPayeer(TransferPayeerCommand command, CancellationToken cancellationToken);
    }
}
