﻿using Farakonesh.Commands.Services.Order;
using Farakonesh.Models.Database;
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading.Tasks;
using System.Threading;
using Farakonesh.Commands.Services;
using Farakonesh.Models.API.ZarinLink;

namespace Farakonesh.Logic.IServices.IApp.IPPG
{
    public interface IZarinLinkService
    {
        Task<DBResult<ResponseGetPayZarinLink>> getPay(GetPayShepaCommand command, CancellationToken cancellationToken, bool checkJobToken = true);
        Task<DBResult> AddRefund(AddRefundZarinLinkCommand command, CancellationToken cancellationToken);
        Task<DBResult> GetCurrentBalance(GetCurrentBalanceCommand command, CancellationToken cancellationToken);
        Task<DBResult> InquiryCardHolder(InquiryCardHolderZarinLinkCommand command, CancellationToken cancellationToken);
        Task<DBResult> GetTransactionDetails(GetTransactionDetailsCommand command, CancellationToken cancellationToken);
        Task<DBResult> getBankAccount(InquiryZarinLinkByIdCommand command, CancellationToken cancellationToken);
        Task<DBResult> settlement(SettlementZarinLinkSettingCommand command, CancellationToken cancellationToken);
        Task<DBResult> getZarinLinkTransaction(InquiryZarinLinkTransaction command, CancellationToken cancellationToken);
        Task<DBResult> startPayChargeWallet(StartPayChargeWalletCommand command, CancellationToken cancellationToken);
        Task<DBResult> startPay(StartPayOrderCommand command, CancellationToken cancellationToken);
        Task<DBResult> startPayPublic(StartPayPublicOrderCommand command, CancellationToken cancellationToken);
        Task<DBResult> getZarinLinkHistory(InquiryZarinLinkCommand command, CancellationToken cancellationToken);
        Task<DBResult> verifyPay(VerifyPayOrderCommand command, CancellationToken cancellationToken);
        Task<DBResult> verifyChargeWallet(VerifyPayChargeCommand command, CancellationToken cancellationToken);
    }
}
